@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.kotlin.outputs.ScheduleEntryResponse
import com.pulumi.azurenative.cache.kotlin.outputs.ScheduleEntryResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PatchSchedule].
 */
@PulumiTagMarker
public class PatchScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PatchScheduleArgs = PatchScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PatchScheduleArgsBuilder.() -> Unit) {
        val builder = PatchScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PatchSchedule {
        val builtJavaResource = com.pulumi.azurenative.cache.PatchSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PatchSchedule(builtJavaResource)
    }
}

/**
 * Response to put/get patch schedules for Redis cache.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-05-01-preview, 2023-08-01.
 * ## Example Usage
 * ### RedisCachePatchSchedulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var patchSchedule = new AzureNative.Cache.PatchSchedule("patchSchedule", new()
 *     {
 *         Default = "default",
 *         Name = "cache1",
 *         ResourceGroupName = "rg1",
 *         ScheduleEntries = new[]
 *         {
 *             new AzureNative.Cache.Inputs.ScheduleEntryArgs
 *             {
 *                 DayOfWeek = AzureNative.Cache.DayOfWeek.Monday,
 *                 MaintenanceWindow = "PT5H",
 *                 StartHourUtc = 12,
 *             },
 *             new AzureNative.Cache.Inputs.ScheduleEntryArgs
 *             {
 *                 DayOfWeek = AzureNative.Cache.DayOfWeek.Tuesday,
 *                 StartHourUtc = 12,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewPatchSchedule(ctx, "patchSchedule", &cache.PatchScheduleArgs{
 * 			Default:           pulumi.String("default"),
 * 			Name:              pulumi.String("cache1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ScheduleEntries: cache.ScheduleEntryArray{
 * 				&cache.ScheduleEntryArgs{
 * 					DayOfWeek:         cache.DayOfWeekMonday,
 * 					MaintenanceWindow: pulumi.String("PT5H"),
 * 					StartHourUtc:      pulumi.Int(12),
 * 				},
 * 				&cache.ScheduleEntryArgs{
 * 					DayOfWeek:    cache.DayOfWeekTuesday,
 * 					StartHourUtc: pulumi.Int(12),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.PatchSchedule;
 * import com.pulumi.azurenative.cache.PatchScheduleArgs;
 * import com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var patchSchedule = new PatchSchedule("patchSchedule", PatchScheduleArgs.builder()
 *             .default_("default")
 *             .name("cache1")
 *             .resourceGroupName("rg1")
 *             .scheduleEntries(
 *                 ScheduleEntryArgs.builder()
 *                     .dayOfWeek("Monday")
 *                     .maintenanceWindow("PT5H")
 *                     .startHourUtc(12)
 *                     .build(),
 *                 ScheduleEntryArgs.builder()
 *                     .dayOfWeek("Tuesday")
 *                     .startHourUtc(12)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:PatchSchedule cachename1/default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}/patchSchedules/{default}
 * ```
 */
public class PatchSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.PatchSchedule,
) : KotlinCustomResource(javaResource, PatchScheduleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of patch schedules for a Redis cache.
     */
    public val scheduleEntries: Output<List<ScheduleEntryResponse>>
        get() = javaResource.scheduleEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PatchScheduleMapper : ResourceMapper<PatchSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.PatchSchedule::class == javaResource::class

    override fun map(javaResource: Resource): PatchSchedule = PatchSchedule(
        javaResource as
            com.pulumi.azurenative.cache.PatchSchedule,
    )
}

/**
 * @see [PatchSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PatchSchedule].
 */
public suspend fun patchSchedule(
    name: String,
    block: suspend PatchScheduleResourceBuilder.() -> Unit,
): PatchSchedule {
    val builder = PatchScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PatchSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun patchSchedule(name: String): PatchSchedule {
    val builder = PatchScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
