@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.cache.kotlin.outputs.RedisAccessKeysResponse
import com.pulumi.azurenative.cache.kotlin.outputs.RedisCommonPropertiesResponseRedisConfiguration
import com.pulumi.azurenative.cache.kotlin.outputs.RedisInstanceDetailsResponse
import com.pulumi.azurenative.cache.kotlin.outputs.RedisLinkedServerResponse
import com.pulumi.azurenative.cache.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cache.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.RedisAccessKeysResponse.Companion.toKotlin as redisAccessKeysResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.RedisCommonPropertiesResponseRedisConfiguration.Companion.toKotlin as redisCommonPropertiesResponseRedisConfigurationToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.RedisInstanceDetailsResponse.Companion.toKotlin as redisInstanceDetailsResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.RedisLinkedServerResponse.Companion.toKotlin as redisLinkedServerResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Redis].
 */
@PulumiTagMarker
public class RedisResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RedisArgs = RedisArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RedisArgsBuilder.() -> Unit) {
        val builder = RedisArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Redis {
        val builtJavaResource = com.pulumi.azurenative.cache.Redis(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Redis(builtJavaResource)
    }
}

/**
 * A single Redis item in List or Get Operation.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2015-08-01, 2017-02-01, 2019-07-01, 2020-06-01, 2023-05-01-preview, 2023-08-01.
 * ## Example Usage
 * ### RedisCacheCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = AzureNative.Cache.TlsVersion.TlsVersion_1_2,
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         RedisVersion = "4",
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = AzureNative.Cache.SkuFamily.P,
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String(cache.TlsVersion_1_2),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			RedisVersion:       pulumi.String("4"),
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String(cache.SkuFamilyP),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs;
 * import com.pulumi.azurenative.cache.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(RedisCommonPropertiesRedisConfigurationArgs.builder()
 *                 .maxmemoryPolicy("allkeys-lru")
 *                 .build())
 *             .redisVersion("4")
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .family("P")
 *                 .name("Premium")
 *                 .build())
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisCacheCreateDefaultVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = AzureNative.Cache.TlsVersion.TlsVersion_1_2,
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = AzureNative.Cache.SkuFamily.P,
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String(cache.TlsVersion_1_2),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String(cache.SkuFamilyP),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs;
 * import com.pulumi.azurenative.cache.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(RedisCommonPropertiesRedisConfigurationArgs.builder()
 *                 .maxmemoryPolicy("allkeys-lru")
 *                 .build())
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .family("P")
 *                 .name("Premium")
 *                 .build())
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisCacheCreateLatestVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = AzureNative.Cache.TlsVersion.TlsVersion_1_2,
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         RedisVersion = "Latest",
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = AzureNative.Cache.SkuFamily.P,
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String(cache.TlsVersion_1_2),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			RedisVersion:       pulumi.String("Latest"),
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String(cache.SkuFamilyP),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs;
 * import com.pulumi.azurenative.cache.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(RedisCommonPropertiesRedisConfigurationArgs.builder()
 *                 .maxmemoryPolicy("allkeys-lru")
 *                 .build())
 *             .redisVersion("Latest")
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .family("P")
 *                 .name("Premium")
 *                 .build())
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:Redis cache1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}
 * ```
 */
public class Redis internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.Redis,
) : KotlinCustomResource(javaResource, RedisMapper) {
    /**
     * The keys of the Redis cache - not set if this object is not the response to Create or Update redis cache
     */
    public val accessKeys: Output<RedisAccessKeysResponse>
        get() = javaResource.accessKeys().applyValue({ args0 ->
            args0.let({ args0 ->
                redisAccessKeysResponseToKotlin(args0)
            })
        })

    /**
     * Specifies whether the non-ssl Redis server port (6379) is enabled.
     */
    public val enableNonSslPort: Output<Boolean>?
        get() = javaResource.enableNonSslPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Redis host name.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The identity of the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of the Redis instances associated with the cache
     */
    public val instances: Output<List<RedisInstanceDetailsResponse>>
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    redisInstanceDetailsResponseToKotlin(args0)
                })
            })
        })

    /**
     * List of the linked servers associated with the cache
     */
    public val linkedServers: Output<List<RedisLinkedServerResponse>>
        get() = javaResource.linkedServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> redisLinkedServerResponseToKotlin(args0) })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    public val minimumTlsVersion: Output<String>?
        get() = javaResource.minimumTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Redis non-SSL port.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connection associated with the specified redis cache
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Redis instance provisioning status.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
     */
    public val redisConfiguration: Output<RedisCommonPropertiesResponseRedisConfiguration>?
        get() = javaResource.redisConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    redisCommonPropertiesResponseRedisConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Redis version. This should be in the form 'major[&#46;minor]' (only 'major' is required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
     */
    public val redisVersion: Output<String>?
        get() = javaResource.redisVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of replicas to be created per primary.
     */
    public val replicasPerMaster: Output<Int>?
        get() = javaResource.replicasPerMaster().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of replicas to be created per primary.
     */
    public val replicasPerPrimary: Output<Int>?
        get() = javaResource.replicasPerPrimary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of shards to be created on a Premium Cluster Cache.
     */
    public val shardCount: Output<Int>?
        get() = javaResource.shardCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the Redis cache to deploy.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Redis SSL port.
     */
    public val sslPort: Output<Int>
        get() = javaResource.sslPort().applyValue({ args0 -> args0 })

    /**
     * Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network; auto assigned by default.
     */
    public val staticIP: Output<String>?
        get() = javaResource.staticIP().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A dictionary of tenant settings
     */
    public val tenantSettings: Output<Map<String, String>>?
        get() = javaResource.tenantSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones denoting where the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object RedisMapper : ResourceMapper<Redis> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.Redis::class == javaResource::class

    override fun map(javaResource: Resource): Redis = Redis(
        javaResource as
            com.pulumi.azurenative.cache.Redis,
    )
}

/**
 * @see [Redis].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Redis].
 */
public suspend fun redis(name: String, block: suspend RedisResourceBuilder.() -> Unit): Redis {
    val builder = RedisResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Redis].
 * @param name The _unique_ name of the resulting resource.
 */
public fun redis(name: String): Redis {
    val builder = RedisResourceBuilder()
    builder.name(name)
    return builder.build()
}
