@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Only userAssignedIdentity is supported in this API version; other types may be supported in the future
 */
public enum class CmkIdentityType(
    public val javaValue: com.pulumi.azurenative.cache.enums.CmkIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.CmkIdentityType> {
    SystemAssignedIdentity(com.pulumi.azurenative.cache.enums.CmkIdentityType.SystemAssignedIdentity),
    UserAssignedIdentity(com.pulumi.azurenative.cache.enums.CmkIdentityType.UserAssignedIdentity),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.CmkIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.CmkIdentityType):
            CmkIdentityType = CmkIdentityType.values().first { it.javaValue == javaType }
    }
}
