@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
 */
public enum class Protocol(
    public val javaValue: com.pulumi.azurenative.cache.enums.Protocol,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.Protocol> {
    Encrypted(com.pulumi.azurenative.cache.enums.Protocol.Encrypted),
    Plaintext(com.pulumi.azurenative.cache.enums.Protocol.Plaintext),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.Protocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.Protocol): Protocol =
            Protocol.values().first { it.javaValue == javaType }
    }
}
