@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ClusterPropertiesEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption-at-rest configuration for the cluster.
 * @property customerManagedKeyEncryption All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
 */
public data class ClusterPropertiesEncryptionArgs(
    public val customerManagedKeyEncryption:
    Output<ClusterPropertiesCustomerManagedKeyEncryptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ClusterPropertiesEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.ClusterPropertiesEncryptionArgs =
        com.pulumi.azurenative.cache.inputs.ClusterPropertiesEncryptionArgs.builder()
            .customerManagedKeyEncryption(
                customerManagedKeyEncryption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ClusterPropertiesEncryptionArgs].
 */
@PulumiTagMarker
public class ClusterPropertiesEncryptionArgsBuilder internal constructor() {
    private var customerManagedKeyEncryption:
        Output<ClusterPropertiesCustomerManagedKeyEncryptionArgs>? = null

    /**
     * @param value All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
     */
    @JvmName("dmxqkbdofjxmysri")
    public suspend
    fun customerManagedKeyEncryption(`value`: Output<ClusterPropertiesCustomerManagedKeyEncryptionArgs>) {
        this.customerManagedKeyEncryption = value
    }

    /**
     * @param value All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
     */
    @JvmName("bountuywhcbgtimt")
    public suspend
    fun customerManagedKeyEncryption(`value`: ClusterPropertiesCustomerManagedKeyEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKeyEncryption = mapped
    }

    /**
     * @param argument All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
     */
    @JvmName("fllmvwxqivjhfyxu")
    public suspend
    fun customerManagedKeyEncryption(argument: suspend ClusterPropertiesCustomerManagedKeyEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPropertiesCustomerManagedKeyEncryptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customerManagedKeyEncryption = mapped
    }

    internal fun build(): ClusterPropertiesEncryptionArgs = ClusterPropertiesEncryptionArgs(
        customerManagedKeyEncryption = customerManagedKeyEncryption,
    )
}
