@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetAccessPolicyAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessPolicyAssignmentName The name of the access policy assignment.
 * @property cacheName The name of the Redis cache.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccessPolicyAssignmentPlainArgs(
    public val accessPolicyAssignmentName: String,
    public val cacheName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetAccessPolicyAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.GetAccessPolicyAssignmentPlainArgs =
        com.pulumi.azurenative.cache.inputs.GetAccessPolicyAssignmentPlainArgs.builder()
            .accessPolicyAssignmentName(accessPolicyAssignmentName.let({ args0 -> args0 }))
            .cacheName(cacheName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPolicyAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPolicyAssignmentPlainArgsBuilder internal constructor() {
    private var accessPolicyAssignmentName: String? = null

    private var cacheName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the access policy assignment.
     */
    @JvmName("oyrmgtohkcpeubos")
    public suspend fun accessPolicyAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessPolicyAssignmentName = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("cxbyhpbbfulrhuhe")
    public suspend fun cacheName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qoqguhrtokddwwmi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessPolicyAssignmentPlainArgs = GetAccessPolicyAssignmentPlainArgs(
        accessPolicyAssignmentName = accessPolicyAssignmentName ?: throw
            PulumiNullFieldException("accessPolicyAssignmentName"),
        cacheName = cacheName ?: throw PulumiNullFieldException("cacheName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
