@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
 * @property keyEncryptionKeyIdentity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyEncryptionKeyUrl Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
 */
public data class ClusterPropertiesResponseCustomerManagedKeyEncryption(
    public val keyEncryptionKeyIdentity: ClusterPropertiesResponseKeyEncryptionKeyIdentity? = null,
    public val keyEncryptionKeyUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.ClusterPropertiesResponseCustomerManagedKeyEncryption):
            ClusterPropertiesResponseCustomerManagedKeyEncryption =
            ClusterPropertiesResponseCustomerManagedKeyEncryption(
                keyEncryptionKeyIdentity = javaType.keyEncryptionKeyIdentity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cache.kotlin.outputs.ClusterPropertiesResponseKeyEncryptionKeyIdentity.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                keyEncryptionKeyUrl = javaType.keyEncryptionKeyUrl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
