@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies configuration of a redis module
 * @property args Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
 * @property name The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
 * @property version The version of the module, e.g. '1.0'.
 */
public data class ModuleResponse(
    public val args: String? = null,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.ModuleResponse):
            ModuleResponse = ModuleResponse(
            args = javaType.args().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
