@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.AFDDomainHttpsParametersResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.DomainValidationPropertiesResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cdn.kotlin.outputs.AFDDomainHttpsParametersResponse.Companion.toKotlin as aFDDomainHttpsParametersResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.DomainValidationPropertiesResponse.Companion.toKotlin as domainValidationPropertiesResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AFDCustomDomain].
 */
@PulumiTagMarker
public class AFDCustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AFDCustomDomainArgs = AFDCustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AFDCustomDomainArgsBuilder.() -> Unit) {
        val builder = AFDCustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AFDCustomDomain {
        val builtJavaResource = com.pulumi.azurenative.cdn.AFDCustomDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AFDCustomDomain(builtJavaResource)
    }
}

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### AFDCustomDomains_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdCustomDomain = new AzureNative.Cdn.AFDCustomDomain("afdCustomDomain", new()
 *     {
 *         AzureDnsZone = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "",
 *         },
 *         CustomDomainName = "domain1",
 *         HostName = "www.someDomain.net",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         TlsSettings = new AzureNative.Cdn.Inputs.AFDDomainHttpsParametersArgs
 *         {
 *             CertificateType = AzureNative.Cdn.AfdCertificateType.ManagedCertificate,
 *             MinimumTlsVersion = AzureNative.Cdn.AfdMinimumTlsVersion.TLS12,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDCustomDomain(ctx, "afdCustomDomain", &cdn.AFDCustomDomainArgs{
 * 			AzureDnsZone: &cdn.ResourceReferenceArgs{
 * 				Id: pulumi.String(""),
 * 			},
 * 			CustomDomainName:  pulumi.String("domain1"),
 * 			HostName:          pulumi.String("www.someDomain.net"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			TlsSettings: &cdn.AFDDomainHttpsParametersArgs{
 * 				CertificateType:   pulumi.String(cdn.AfdCertificateTypeManagedCertificate),
 * 				MinimumTlsVersion: cdn.AfdMinimumTlsVersionTLS12,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDCustomDomain;
 * import com.pulumi.azurenative.cdn.AFDCustomDomainArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdCustomDomain = new AFDCustomDomain("afdCustomDomain", AFDCustomDomainArgs.builder()
 *             .azureDnsZone(ResourceReferenceArgs.builder()
 *                 .id("")
 *                 .build())
 *             .customDomainName("domain1")
 *             .hostName("www.someDomain.net")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .tlsSettings(AFDDomainHttpsParametersArgs.builder()
 *                 .certificateType("ManagedCertificate")
 *                 .minimumTlsVersion("TLS12")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDCustomDomain domain1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}
 * ```
 */
public class AFDCustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.AFDCustomDomain,
) : KotlinCustomResource(javaResource, AFDCustomDomainMapper) {
    /**
     * Resource reference to the Azure DNS zone
     */
    public val azureDnsZone: Output<ResourceReferenceResponse>?
        get() = javaResource.azureDnsZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceReferenceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands for DomainControlValidation.
     */
    public val domainValidationState: Output<String>
        get() = javaResource.domainValidationState().applyValue({ args0 -> args0 })

    /**
     * Key-Value pair representing migration properties for domains.
     */
    public val extendedProperties: Output<Map<String, String>>?
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The host name of the domain. Must be a domain name.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource reference to the Azure resource where custom domain ownership was prevalidated
     */
    public val preValidatedCustomDomainResourceId: Output<ResourceReferenceResponse>?
        get() = javaResource.preValidatedCustomDomainResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceReferenceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the profile which holds the domain.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     */
    public val tlsSettings: Output<AFDDomainHttpsParametersResponse>?
        get() = javaResource.tlsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    aFDDomainHttpsParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Values the customer needs to validate domain ownership
     */
    public val validationProperties: Output<DomainValidationPropertiesResponse>
        get() = javaResource.validationProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                domainValidationPropertiesResponseToKotlin(args0)
            })
        })
}

public object AFDCustomDomainMapper : ResourceMapper<AFDCustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.AFDCustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): AFDCustomDomain = AFDCustomDomain(
        javaResource as
            com.pulumi.azurenative.cdn.AFDCustomDomain,
    )
}

/**
 * @see [AFDCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AFDCustomDomain].
 */
public suspend fun afdCustomDomain(
    name: String,
    block: suspend AFDCustomDomainResourceBuilder.() -> Unit,
): AFDCustomDomain {
    val builder = AFDCustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AFDCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun afdCustomDomain(name: String): AFDCustomDomain {
    val builder = AFDCustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
