@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.AFDCustomDomainArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.AFDDomainHttpsParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.AFDDomainHttpsParametersArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### AFDCustomDomains_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdCustomDomain = new AzureNative.Cdn.AFDCustomDomain("afdCustomDomain", new()
 *     {
 *         AzureDnsZone = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "",
 *         },
 *         CustomDomainName = "domain1",
 *         HostName = "www.someDomain.net",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         TlsSettings = new AzureNative.Cdn.Inputs.AFDDomainHttpsParametersArgs
 *         {
 *             CertificateType = AzureNative.Cdn.AfdCertificateType.ManagedCertificate,
 *             MinimumTlsVersion = AzureNative.Cdn.AfdMinimumTlsVersion.TLS12,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDCustomDomain(ctx, "afdCustomDomain", &cdn.AFDCustomDomainArgs{
 * 			AzureDnsZone: &cdn.ResourceReferenceArgs{
 * 				Id: pulumi.String(""),
 * 			},
 * 			CustomDomainName:  pulumi.String("domain1"),
 * 			HostName:          pulumi.String("www.someDomain.net"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			TlsSettings: &cdn.AFDDomainHttpsParametersArgs{
 * 				CertificateType:   pulumi.String(cdn.AfdCertificateTypeManagedCertificate),
 * 				MinimumTlsVersion: cdn.AfdMinimumTlsVersionTLS12,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDCustomDomain;
 * import com.pulumi.azurenative.cdn.AFDCustomDomainArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdCustomDomain = new AFDCustomDomain("afdCustomDomain", AFDCustomDomainArgs.builder()
 *             .azureDnsZone(ResourceReferenceArgs.builder()
 *                 .id("")
 *                 .build())
 *             .customDomainName("domain1")
 *             .hostName("www.someDomain.net")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .tlsSettings(AFDDomainHttpsParametersArgs.builder()
 *                 .certificateType("ManagedCertificate")
 *                 .minimumTlsVersion("TLS12")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDCustomDomain domain1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}
 * ```
 * @property azureDnsZone Resource reference to the Azure DNS zone
 * @property customDomainName Name of the domain under the profile which is unique globally
 * @property extendedProperties Key-Value pair representing migration properties for domains.
 * @property hostName The host name of the domain. Must be a domain name.
 * @property preValidatedCustomDomainResourceId Resource reference to the Azure resource where custom domain ownership was prevalidated
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
 */
public data class AFDCustomDomainArgs(
    public val azureDnsZone: Output<ResourceReferenceArgs>? = null,
    public val customDomainName: Output<String>? = null,
    public val extendedProperties: Output<Map<String, String>>? = null,
    public val hostName: Output<String>? = null,
    public val preValidatedCustomDomainResourceId: Output<ResourceReferenceArgs>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tlsSettings: Output<AFDDomainHttpsParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.AFDCustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.AFDCustomDomainArgs =
        com.pulumi.azurenative.cdn.AFDCustomDomainArgs.builder()
            .azureDnsZone(azureDnsZone?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customDomainName(customDomainName?.applyValue({ args0 -> args0 }))
            .extendedProperties(
                extendedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .preValidatedCustomDomainResourceId(
                preValidatedCustomDomainResourceId?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tlsSettings(tlsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AFDCustomDomainArgs].
 */
@PulumiTagMarker
public class AFDCustomDomainArgsBuilder internal constructor() {
    private var azureDnsZone: Output<ResourceReferenceArgs>? = null

    private var customDomainName: Output<String>? = null

    private var extendedProperties: Output<Map<String, String>>? = null

    private var hostName: Output<String>? = null

    private var preValidatedCustomDomainResourceId: Output<ResourceReferenceArgs>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tlsSettings: Output<AFDDomainHttpsParametersArgs>? = null

    /**
     * @param value Resource reference to the Azure DNS zone
     */
    @JvmName("bboqqrhdkflnnrge")
    public suspend fun azureDnsZone(`value`: Output<ResourceReferenceArgs>) {
        this.azureDnsZone = value
    }

    /**
     * @param value Name of the domain under the profile which is unique globally
     */
    @JvmName("xrxrkrflvtrhivyp")
    public suspend fun customDomainName(`value`: Output<String>) {
        this.customDomainName = value
    }

    /**
     * @param value Key-Value pair representing migration properties for domains.
     */
    @JvmName("whbcjkxnngsowtne")
    public suspend fun extendedProperties(`value`: Output<Map<String, String>>) {
        this.extendedProperties = value
    }

    /**
     * @param value The host name of the domain. Must be a domain name.
     */
    @JvmName("adykuaockcidsqlb")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource reference to the Azure resource where custom domain ownership was prevalidated
     */
    @JvmName("dwmafadequfxjert")
    public suspend fun preValidatedCustomDomainResourceId(`value`: Output<ResourceReferenceArgs>) {
        this.preValidatedCustomDomainResourceId = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("biwxnalwkevadgms")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("naprqmyytdboswjq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     */
    @JvmName("hlcacauqfoddiaig")
    public suspend fun tlsSettings(`value`: Output<AFDDomainHttpsParametersArgs>) {
        this.tlsSettings = value
    }

    /**
     * @param value Resource reference to the Azure DNS zone
     */
    @JvmName("aocgatkigsywsswq")
    public suspend fun azureDnsZone(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDnsZone = mapped
    }

    /**
     * @param argument Resource reference to the Azure DNS zone
     */
    @JvmName("jceyjjgfyxcsiggn")
    public suspend fun azureDnsZone(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureDnsZone = mapped
    }

    /**
     * @param value Name of the domain under the profile which is unique globally
     */
    @JvmName("qwkfciixnoeujite")
    public suspend fun customDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainName = mapped
    }

    /**
     * @param value Key-Value pair representing migration properties for domains.
     */
    @JvmName("rncnopcyugvqihyi")
    public suspend fun extendedProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param values Key-Value pair representing migration properties for domains.
     */
    @JvmName("xbbsatyrdrtwyigv")
    public fun extendedProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param value The host name of the domain. Must be a domain name.
     */
    @JvmName("huywdcbrrokpmsep")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource reference to the Azure resource where custom domain ownership was prevalidated
     */
    @JvmName("qfxmrphkhitsbvws")
    public suspend fun preValidatedCustomDomainResourceId(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preValidatedCustomDomainResourceId = mapped
    }

    /**
     * @param argument Resource reference to the Azure resource where custom domain ownership was prevalidated
     */
    @JvmName("xdrijmppjpjevslc")
    public suspend
    fun preValidatedCustomDomainResourceId(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preValidatedCustomDomainResourceId = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("iyjaaijcrwiykqwb")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("pcddesqjbffwojsv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     */
    @JvmName("kviimqbsiigvgrat")
    public suspend fun tlsSettings(`value`: AFDDomainHttpsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsSettings = mapped
    }

    /**
     * @param argument The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     */
    @JvmName("ckrviuruaxqdgmlq")
    public suspend fun tlsSettings(argument: suspend AFDDomainHttpsParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AFDDomainHttpsParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tlsSettings = mapped
    }

    internal fun build(): AFDCustomDomainArgs = AFDCustomDomainArgs(
        azureDnsZone = azureDnsZone,
        customDomainName = customDomainName,
        extendedProperties = extendedProperties,
        hostName = hostName,
        preValidatedCustomDomainResourceId = preValidatedCustomDomainResourceId,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        tlsSettings = tlsSettings,
    )
}
