@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.AFDOriginArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.EnabledState
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.SharedPrivateLinkResourcePropertiesArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.SharedPrivateLinkResourcePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### AFDOrigins_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdOrigin = new AzureNative.Cdn.AFDOrigin("afdOrigin", new()
 *     {
 *         EnabledState = AzureNative.Cdn.EnabledState.Enabled,
 *         HostName = "host1.blob.core.windows.net",
 *         HttpPort = 80,
 *         HttpsPort = 443,
 *         OriginGroupName = "origingroup1",
 *         OriginHostHeader = "host1.foo.com",
 *         OriginName = "origin1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDOrigin(ctx, "afdOrigin", &cdn.AFDOriginArgs{
 * 			EnabledState:      pulumi.String(cdn.EnabledStateEnabled),
 * 			HostName:          pulumi.String("host1.blob.core.windows.net"),
 * 			HttpPort:          pulumi.Int(80),
 * 			HttpsPort:         pulumi.Int(443),
 * 			OriginGroupName:   pulumi.String("origingroup1"),
 * 			OriginHostHeader:  pulumi.String("host1.foo.com"),
 * 			OriginName:        pulumi.String("origin1"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDOrigin;
 * import com.pulumi.azurenative.cdn.AFDOriginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdOrigin = new AFDOrigin("afdOrigin", AFDOriginArgs.builder()
 *             .enabledState("Enabled")
 *             .hostName("host1.blob.core.windows.net")
 *             .httpPort(80)
 *             .httpsPort(443)
 *             .originGroupName("origingroup1")
 *             .originHostHeader("host1.foo.com")
 *             .originName("origin1")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDOrigin origin1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}
 * ```
 * @property azureOrigin Resource reference to the Azure origin resource.
 * @property enabledState Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
 * @property enforceCertificateNameCheck Whether to enable certificate name check at origin level
 * @property hostName The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
 * @property httpPort The value of the HTTP port. Must be between 1 and 65535.
 * @property httpsPort The value of the HTTPS port. Must be between 1 and 65535.
 * @property originGroupName Name of the origin group which is unique within the profile.
 * @property originHostHeader The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
 * @property originName Name of the origin that is unique within the profile.
 * @property priority Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sharedPrivateLinkResource The properties of the private link resource for private origin.
 * @property weight Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
 */
public data class AFDOriginArgs(
    public val azureOrigin: Output<ResourceReferenceArgs>? = null,
    public val enabledState: Output<Either<String, EnabledState>>? = null,
    public val enforceCertificateNameCheck: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val httpPort: Output<Int>? = null,
    public val httpsPort: Output<Int>? = null,
    public val originGroupName: Output<String>? = null,
    public val originHostHeader: Output<String>? = null,
    public val originName: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedPrivateLinkResource: Output<SharedPrivateLinkResourcePropertiesArgs>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.AFDOriginArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.AFDOriginArgs =
        com.pulumi.azurenative.cdn.AFDOriginArgs.builder()
            .azureOrigin(azureOrigin?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enforceCertificateNameCheck(enforceCertificateNameCheck?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .httpPort(httpPort?.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort?.applyValue({ args0 -> args0 }))
            .originGroupName(originGroupName?.applyValue({ args0 -> args0 }))
            .originHostHeader(originHostHeader?.applyValue({ args0 -> args0 }))
            .originName(originName?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedPrivateLinkResource(
                sharedPrivateLinkResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AFDOriginArgs].
 */
@PulumiTagMarker
public class AFDOriginArgsBuilder internal constructor() {
    private var azureOrigin: Output<ResourceReferenceArgs>? = null

    private var enabledState: Output<Either<String, EnabledState>>? = null

    private var enforceCertificateNameCheck: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var originGroupName: Output<String>? = null

    private var originHostHeader: Output<String>? = null

    private var originName: Output<String>? = null

    private var priority: Output<Int>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedPrivateLinkResource: Output<SharedPrivateLinkResourcePropertiesArgs>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Resource reference to the Azure origin resource.
     */
    @JvmName("avyywlxbjjchuiay")
    public suspend fun azureOrigin(`value`: Output<ResourceReferenceArgs>) {
        this.azureOrigin = value
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("wfwhlsnpqgeqbejr")
    public suspend fun enabledState(`value`: Output<Either<String, EnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Whether to enable certificate name check at origin level
     */
    @JvmName("nwdtwtgggpiiiiid")
    public suspend fun enforceCertificateNameCheck(`value`: Output<Boolean>) {
        this.enforceCertificateNameCheck = value
    }

    /**
     * @param value The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     */
    @JvmName("xhxlwudjsttjculv")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("vyrylgrepkuvwaqx")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("dqsiflqfiekadenp")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value Name of the origin group which is unique within the profile.
     */
    @JvmName("jqiiiemswlvrugtt")
    public suspend fun originGroupName(`value`: Output<String>) {
        this.originGroupName = value
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
     */
    @JvmName("xgiithlnsbxxbgyh")
    public suspend fun originHostHeader(`value`: Output<String>) {
        this.originHostHeader = value
    }

    /**
     * @param value Name of the origin that is unique within the profile.
     */
    @JvmName("qsxoesvdhcbtglai")
    public suspend fun originName(`value`: Output<String>) {
        this.originName = value
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
     */
    @JvmName("tvlainloauajtsek")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("fqqcukujooattmts")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("imprmfqictsbfqql")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The properties of the private link resource for private origin.
     */
    @JvmName("rrpalgvipgclhbgs")
    public suspend
    fun sharedPrivateLinkResource(`value`: Output<SharedPrivateLinkResourcePropertiesArgs>) {
        this.sharedPrivateLinkResource = value
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("jaacngflbjllmvjw")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Resource reference to the Azure origin resource.
     */
    @JvmName("esrmibnbtvdgjxjv")
    public suspend fun azureOrigin(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOrigin = mapped
    }

    /**
     * @param argument Resource reference to the Azure origin resource.
     */
    @JvmName("krmqxpicmkupvixm")
    public suspend fun azureOrigin(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureOrigin = mapped
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("iaxsbolixyjxlcak")
    public suspend fun enabledState(`value`: Either<String, EnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("vatqmmsupngfnmji")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("msciqrlcwcubeowh")
    public fun enabledState(`value`: EnabledState) {
        val toBeMapped = Either.ofRight<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable certificate name check at origin level
     */
    @JvmName("klgmikiksiecoqga")
    public suspend fun enforceCertificateNameCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceCertificateNameCheck = mapped
    }

    /**
     * @param value The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     */
    @JvmName("itgjssdxekkphvvj")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("xuuhmyvrxkntpiul")
    public suspend fun httpPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("yqncpvvliqeqkcyh")
    public suspend fun httpsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value Name of the origin group which is unique within the profile.
     */
    @JvmName("aaxplodowldyyjik")
    public suspend fun originGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroupName = mapped
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
     */
    @JvmName("mxxuetcouwgificu")
    public suspend fun originHostHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originHostHeader = mapped
    }

    /**
     * @param value Name of the origin that is unique within the profile.
     */
    @JvmName("unsqmpenrjqqvrar")
    public suspend fun originName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originName = mapped
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
     */
    @JvmName("qpxmluretbmlyjoh")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("mtsfqcexstvpyxps")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jcjpfnyvhhaeiybh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The properties of the private link resource for private origin.
     */
    @JvmName("hndvjlxkbvcumlth")
    public suspend fun sharedPrivateLinkResource(`value`: SharedPrivateLinkResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResource = mapped
    }

    /**
     * @param argument The properties of the private link resource for private origin.
     */
    @JvmName("egsgwlgrywesmgak")
    public suspend
    fun sharedPrivateLinkResource(argument: suspend SharedPrivateLinkResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SharedPrivateLinkResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedPrivateLinkResource = mapped
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("qhwfxdnogelbbkqq")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): AFDOriginArgs = AFDOriginArgs(
        azureOrigin = azureOrigin,
        enabledState = enabledState,
        enforceCertificateNameCheck = enforceCertificateNameCheck,
        hostName = hostName,
        httpPort = httpPort,
        httpsPort = httpsPort,
        originGroupName = originGroupName,
        originHostHeader = originHostHeader,
        originName = originName,
        priority = priority,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        sharedPrivateLinkResource = sharedPrivateLinkResource,
        weight = weight,
    )
}
