@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.HealthProbeParametersResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.LoadBalancingSettingsParametersResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cdn.kotlin.outputs.HealthProbeParametersResponse.Companion.toKotlin as healthProbeParametersResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.LoadBalancingSettingsParametersResponse.Companion.toKotlin as loadBalancingSettingsParametersResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AFDOriginGroup].
 */
@PulumiTagMarker
public class AFDOriginGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AFDOriginGroupArgs = AFDOriginGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AFDOriginGroupArgsBuilder.() -> Unit) {
        val builder = AFDOriginGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AFDOriginGroup {
        val builtJavaResource = com.pulumi.azurenative.cdn.AFDOriginGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AFDOriginGroup(builtJavaResource)
    }
}

/**
 * AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### AFDOriginGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdOriginGroup = new AzureNative.Cdn.AFDOriginGroup("afdOriginGroup", new()
 *     {
 *         HealthProbeSettings = new AzureNative.Cdn.Inputs.HealthProbeParametersArgs
 *         {
 *             ProbeIntervalInSeconds = 10,
 *             ProbePath = "/path2",
 *             ProbeProtocol = AzureNative.Cdn.ProbeProtocol.NotSet,
 *             ProbeRequestType = AzureNative.Cdn.HealthProbeRequestType.NotSet,
 *         },
 *         LoadBalancingSettings = new AzureNative.Cdn.Inputs.LoadBalancingSettingsParametersArgs
 *         {
 *             AdditionalLatencyInMilliseconds = 1000,
 *             SampleSize = 3,
 *             SuccessfulSamplesRequired = 3,
 *         },
 *         OriginGroupName = "origingroup1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         TrafficRestorationTimeToHealedOrNewEndpointsInMinutes = 5,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDOriginGroup(ctx, "afdOriginGroup", &cdn.AFDOriginGroupArgs{
 * 			HealthProbeSettings: &cdn.HealthProbeParametersArgs{
 * 				ProbeIntervalInSeconds: pulumi.Int(10),
 * 				ProbePath:              pulumi.String("/path2"),
 * 				ProbeProtocol:          cdn.ProbeProtocolNotSet,
 * 				ProbeRequestType:       cdn.HealthProbeRequestTypeNotSet,
 * 			},
 * 			LoadBalancingSettings: &cdn.LoadBalancingSettingsParametersArgs{
 * 				AdditionalLatencyInMilliseconds: pulumi.Int(1000),
 * 				SampleSize:                      pulumi.Int(3),
 * 				SuccessfulSamplesRequired:       pulumi.Int(3),
 * 			},
 * 			OriginGroupName:   pulumi.String("origingroup1"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			TrafficRestorationTimeToHealedOrNewEndpointsInMinutes: pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDOriginGroup;
 * import com.pulumi.azurenative.cdn.AFDOriginGroupArgs;
 * import com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.LoadBalancingSettingsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdOriginGroup = new AFDOriginGroup("afdOriginGroup", AFDOriginGroupArgs.builder()
 *             .healthProbeSettings(HealthProbeParametersArgs.builder()
 *                 .probeIntervalInSeconds(10)
 *                 .probePath("/path2")
 *                 .probeProtocol("NotSet")
 *                 .probeRequestType("NotSet")
 *                 .build())
 *             .loadBalancingSettings(LoadBalancingSettingsParametersArgs.builder()
 *                 .additionalLatencyInMilliseconds(1000)
 *                 .sampleSize(3)
 *                 .successfulSamplesRequired(3)
 *                 .build())
 *             .originGroupName("origingroup1")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .trafficRestorationTimeToHealedOrNewEndpointsInMinutes(5)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDOriginGroup origingroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}
 * ```
 */
public class AFDOriginGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.AFDOriginGroup,
) : KotlinCustomResource(javaResource, AFDOriginGroupMapper) {
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Health probe settings to the origin that is used to determine the health of the origin.
     */
    public val healthProbeSettings: Output<HealthProbeParametersResponse>?
        get() = javaResource.healthProbeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> healthProbeParametersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Load balancing settings for a backend pool
     */
    public val loadBalancingSettings: Output<LoadBalancingSettingsParametersResponse>?
        get() = javaResource.loadBalancingSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancingSettingsParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the profile which holds the origin group.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    public val sessionAffinityState: Output<String>?
        get() = javaResource.sessionAffinityState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>?
        get() =
            javaResource.trafficRestorationTimeToHealedOrNewEndpointsInMinutes().applyValue({ args0 ->
                args0.map({ args0 -> args0 }).orElse(null)
            })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AFDOriginGroupMapper : ResourceMapper<AFDOriginGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.AFDOriginGroup::class == javaResource::class

    override fun map(javaResource: Resource): AFDOriginGroup = AFDOriginGroup(
        javaResource as
            com.pulumi.azurenative.cdn.AFDOriginGroup,
    )
}

/**
 * @see [AFDOriginGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AFDOriginGroup].
 */
public suspend fun afdOriginGroup(
    name: String,
    block: suspend AFDOriginGroupResourceBuilder.() -> Unit,
): AFDOriginGroup {
    val builder = AFDOriginGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AFDOriginGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun afdOriginGroup(name: String): AFDOriginGroup {
    val builder = AFDOriginGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
