@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.PolicyArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.CustomRuleListArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.CustomRuleListArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ManagedRuleSetListArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ManagedRuleSetListArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.PolicySettingsArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.PolicySettingsArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.RateLimitRuleListArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.RateLimitRuleListArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines web application firewall policy for Azure CDN.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Cdn.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Cdn.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.CustomRuleArgs
 *                 {
 *                     Action = AzureNative.Cdn.ActionType.Block,
 *                     EnabledState = AzureNative.Cdn.CustomRuleEnabledState.Enabled,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RemoteAddr,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.GeoMatch,
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RequestHeader,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.Contains,
 *                             Selector = "UserAgent",
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "<?php",
 *                                 "?>",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.QueryString,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.Contains,
 *                             Selector = "search",
 *                             Transforms = new[]
 *                             {
 *                                 AzureNative.Cdn.TransformType.UrlDecode,
 *                                 AzureNative.Cdn.TransformType.Lowercase,
 *                             },
 *                         },
 *                     },
 *                     Name = "CustomRule1",
 *                     Priority = 2,
 *                 },
 *             },
 *         },
 *         Location = "global",
 *         ManagedRules = new AzureNative.Cdn.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "Group1",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Cdn.ActionType.Redirect,
 *                                     EnabledState = AzureNative.Cdn.ManagedRuleEnabledState.Enabled,
 *                                     RuleId = "GROUP1-0001",
 *                                 },
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = AzureNative.Cdn.ManagedRuleEnabledState.Disabled,
 *                                     RuleId = "GROUP1-0002",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "preview-1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "MicrosoftCdnWafPolicy",
 *         PolicySettings = new AzureNative.Cdn.Inputs.PolicySettingsArgs
 *         {
 *             DefaultCustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             DefaultCustomBlockResponseStatusCode = 200,
 *             DefaultRedirectUrl = "http://www.bing.com",
 *         },
 *         RateLimitRules = new AzureNative.Cdn.Inputs.RateLimitRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.RateLimitRuleArgs
 *                 {
 *                     Action = AzureNative.Cdn.ActionType.Block,
 *                     EnabledState = AzureNative.Cdn.CustomRuleEnabledState.Enabled,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RemoteAddr,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.IPMatch,
 *                             Transforms = new() { },
 *                         },
 *                     },
 *                     Name = "RateLimitRule1",
 *                     Priority = 1,
 *                     RateLimitDurationInMinutes = 0,
 *                     RateLimitThreshold = 1000,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Cdn.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Cdn.SkuName.Standard_Microsoft,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewPolicy(ctx, "policy", &cdn.PolicyArgs{
 * 			CustomRules: &cdn.CustomRuleListArgs{
 * 				Rules: cdn.CustomRuleArray{
 * 					&cdn.CustomRuleArgs{
 * 						Action:       pulumi.String(cdn.ActionTypeBlock),
 * 						EnabledState: pulumi.String(cdn.CustomRuleEnabledStateEnabled),
 * 						MatchConditions: cdn.MatchConditionArray{
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("CH"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRemoteAddr),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorGeoMatch),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("windows"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRequestHeader),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorContains),
 * 								Selector:        pulumi.String("UserAgent"),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("<?php"),
 * 									pulumi.String("?>"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableQueryString),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorContains),
 * 								Selector:        pulumi.String("search"),
 * 								Transforms: pulumi.StringArray{
 * 									pulumi.String(cdn.TransformTypeUrlDecode),
 * 									pulumi.String(cdn.TransformTypeLowercase),
 * 								},
 * 							},
 * 						},
 * 						Name:     pulumi.String("CustomRule1"),
 * 						Priority: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			ManagedRules: &cdn.ManagedRuleSetListArgs{
 * 				ManagedRuleSets: cdn.ManagedRuleSetArray{
 * 					&cdn.ManagedRuleSetArgs{
 * 						RuleGroupOverrides: cdn.ManagedRuleGroupOverrideArray{
 * 							&cdn.ManagedRuleGroupOverrideArgs{
 * 								RuleGroupName: pulumi.String("Group1"),
 * 								Rules: cdn.ManagedRuleOverrideArray{
 * 									&cdn.ManagedRuleOverrideArgs{
 * 										Action:       pulumi.String(cdn.ActionTypeRedirect),
 * 										EnabledState: pulumi.String(cdn.ManagedRuleEnabledStateEnabled),
 * 										RuleId:       pulumi.String("GROUP1-0001"),
 * 									},
 * 									&cdn.ManagedRuleOverrideArgs{
 * 										EnabledState: pulumi.String(cdn.ManagedRuleEnabledStateDisabled),
 * 										RuleId:       pulumi.String("GROUP1-0002"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RuleSetType:    pulumi.String("DefaultRuleSet"),
 * 						RuleSetVersion: pulumi.String("preview-1.0"),
 * 					},
 * 				},
 * 			},
 * 			PolicyName: pulumi.String("MicrosoftCdnWafPolicy"),
 * 			PolicySettings: &cdn.PolicySettingsArgs{
 * 				DefaultCustomBlockResponseBody:       pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * 				DefaultCustomBlockResponseStatusCode: pulumi.Int(200),
 * 				DefaultRedirectUrl:                   pulumi.String("http://www.bing.com"),
 * 			},
 * 			RateLimitRules: &cdn.RateLimitRuleListArgs{
 * 				Rules: cdn.RateLimitRuleArray{
 * 					&cdn.RateLimitRuleArgs{
 * 						Action:       pulumi.String(cdn.ActionTypeBlock),
 * 						EnabledState: pulumi.String(cdn.CustomRuleEnabledStateEnabled),
 * 						MatchConditions: cdn.MatchConditionArray{
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("192.168.1.0/24"),
 * 									pulumi.String("10.0.0.0/24"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRemoteAddr),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorIPMatch),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 						},
 * 						Name:                       pulumi.String("RateLimitRule1"),
 * 						Priority:                   pulumi.Int(1),
 * 						RateLimitDurationInMinutes: pulumi.Int(0),
 * 						RateLimitThreshold:         pulumi.Int(1000),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &cdn.SkuArgs{
 * 				Name: pulumi.String(cdn.SkuName_Standard_Microsoft),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Policy;
 * import com.pulumi.azurenative.cdn.PolicyArgs;
 * import com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs;
 * import com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs;
 * import com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs;
 * import com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs;
 * import com.pulumi.azurenative.cdn.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(CustomRuleListArgs.builder()
 *                 .rules(CustomRuleArgs.builder()
 *                     .action("Block")
 *                     .enabledState("Enabled")
 *                     .matchConditions(
 *                         MatchConditionArgs.builder()
 *                             .matchValue("CH")
 *                             .matchVariable("RemoteAddr")
 *                             .negateCondition(false)
 *                             .operator("GeoMatch")
 *                             .transforms()
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValue("windows")
 *                             .matchVariable("RequestHeader")
 *                             .negateCondition(false)
 *                             .operator("Contains")
 *                             .selector("UserAgent")
 *                             .transforms()
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValue(
 *                                 "<?php",
 *                                 "?>")
 *                             .matchVariable("QueryString")
 *                             .negateCondition(false)
 *                             .operator("Contains")
 *                             .selector("search")
 *                             .transforms(
 *                                 "UrlDecode",
 *                                 "Lowercase")
 *                             .build())
 *                     .name("CustomRule1")
 *                     .priority(2)
 *                     .build())
 *                 .build())
 *             .location("global")
 *             .managedRules(ManagedRuleSetListArgs.builder()
 *                 .managedRuleSets(ManagedRuleSetArgs.builder()
 *                     .ruleGroupOverrides(ManagedRuleGroupOverrideArgs.builder()
 *                         .ruleGroupName("Group1")
 *                         .rules(
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("Redirect")
 *                                 .enabledState("Enabled")
 *                                 .ruleId("GROUP1-0001")
 *                                 .build(),
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .enabledState("Disabled")
 *                                 .ruleId("GROUP1-0002")
 *                                 .build())
 *                         .build())
 *                     .ruleSetType("DefaultRuleSet")
 *                     .ruleSetVersion("preview-1.0")
 *                     .build())
 *                 .build())
 *             .policyName("MicrosoftCdnWafPolicy")
 *             .policySettings(PolicySettingsArgs.builder()
 *                 .defaultCustomBlockResponseBody("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==")
 *                 .defaultCustomBlockResponseStatusCode(200)
 *                 .defaultRedirectUrl("http://www.bing.com")
 *                 .build())
 *             .rateLimitRules(RateLimitRuleListArgs.builder()
 *                 .rules(RateLimitRuleArgs.builder()
 *                     .action("Block")
 *                     .enabledState("Enabled")
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValue(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariable("RemoteAddr")
 *                         .negateCondition(false)
 *                         .operator("IPMatch")
 *                         .transforms()
 *                         .build())
 *                     .name("RateLimitRule1")
 *                     .priority(1)
 *                     .rateLimitDurationInMinutes(0)
 *                     .rateLimitThreshold(1000)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_Microsoft")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Policy MicrosoftCdnWafPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/cdnWebApplicationFirewallPolicies/{policyName}
 * ```
 * @property customRules Describes custom rules inside the policy.
 * @property extendedProperties Key-Value pair representing additional properties for Web Application Firewall policy.
 * @property location Resource location.
 * @property managedRules Describes managed rules inside the policy.
 * @property policyName The name of the CdnWebApplicationFirewallPolicy.
 * @property policySettings Describes  policySettings for policy
 * @property rateLimitRules Describes rate limit rules inside the policy.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sku The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
 * @property tags Resource tags.
 */
public data class PolicyArgs(
    public val customRules: Output<CustomRuleListArgs>? = null,
    public val extendedProperties: Output<Map<String, String>>? = null,
    public val location: Output<String>? = null,
    public val managedRules: Output<ManagedRuleSetListArgs>? = null,
    public val policyName: Output<String>? = null,
    public val policySettings: Output<PolicySettingsArgs>? = null,
    public val rateLimitRules: Output<RateLimitRuleListArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.PolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.PolicyArgs =
        com.pulumi.azurenative.cdn.PolicyArgs.builder()
            .customRules(customRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedProperties(
                extendedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managedRules(managedRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policySettings(policySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rateLimitRules(rateLimitRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var customRules: Output<CustomRuleListArgs>? = null

    private var extendedProperties: Output<Map<String, String>>? = null

    private var location: Output<String>? = null

    private var managedRules: Output<ManagedRuleSetListArgs>? = null

    private var policyName: Output<String>? = null

    private var policySettings: Output<PolicySettingsArgs>? = null

    private var rateLimitRules: Output<RateLimitRuleListArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Describes custom rules inside the policy.
     */
    @JvmName("uqxeaaeldwvbseyt")
    public suspend fun customRules(`value`: Output<CustomRuleListArgs>) {
        this.customRules = value
    }

    /**
     * @param value Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    @JvmName("aewrvrigradkolgg")
    public suspend fun extendedProperties(`value`: Output<Map<String, String>>) {
        this.extendedProperties = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qicwjhonilyeputs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Describes managed rules inside the policy.
     */
    @JvmName("tssyiormdrncvkvg")
    public suspend fun managedRules(`value`: Output<ManagedRuleSetListArgs>) {
        this.managedRules = value
    }

    /**
     * @param value The name of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("nmuyohvlwqssxgvu")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Describes  policySettings for policy
     */
    @JvmName("fkhkowxqekvtjxra")
    public suspend fun policySettings(`value`: Output<PolicySettingsArgs>) {
        this.policySettings = value
    }

    /**
     * @param value Describes rate limit rules inside the policy.
     */
    @JvmName("xflultivnbsutqxd")
    public suspend fun rateLimitRules(`value`: Output<RateLimitRuleListArgs>) {
        this.rateLimitRules = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("roymxwvtclwvlafm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("adsvvnflkmtxvadl")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rtsudtksldbdhvht")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes custom rules inside the policy.
     */
    @JvmName("xykmwuadbtxyyxvg")
    public suspend fun customRules(`value`: CustomRuleListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument Describes custom rules inside the policy.
     */
    @JvmName("lrynfxofwhbdgjni")
    public suspend fun customRules(argument: suspend CustomRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = CustomRuleListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param value Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    @JvmName("jwtjkuoagleguddd")
    public suspend fun extendedProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param values Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    @JvmName("umjihbfohujsvemn")
    public fun extendedProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ypieboustbjlcebv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Describes managed rules inside the policy.
     */
    @JvmName("qhjhumelkoscqfbw")
    public suspend fun managedRules(`value`: ManagedRuleSetListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRules = mapped
    }

    /**
     * @param argument Describes managed rules inside the policy.
     */
    @JvmName("skojourlwrevwwly")
    public suspend fun managedRules(argument: suspend ManagedRuleSetListArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRuleSetListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedRules = mapped
    }

    /**
     * @param value The name of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("pmxhqyqgtdvyscms")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Describes  policySettings for policy
     */
    @JvmName("qkkpgufilnciqdcc")
    public suspend fun policySettings(`value`: PolicySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySettings = mapped
    }

    /**
     * @param argument Describes  policySettings for policy
     */
    @JvmName("ordwhfnyrmnshvjh")
    public suspend fun policySettings(argument: suspend PolicySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policySettings = mapped
    }

    /**
     * @param value Describes rate limit rules inside the policy.
     */
    @JvmName("lqvmigiogmiohqws")
    public suspend fun rateLimitRules(`value`: RateLimitRuleListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitRules = mapped
    }

    /**
     * @param argument Describes rate limit rules inside the policy.
     */
    @JvmName("fjlunlpskrnlbpva")
    public suspend fun rateLimitRules(argument: suspend RateLimitRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = RateLimitRuleListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rateLimitRules = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("sfgrwncmfajknapy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("owxejginisrepxpm")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("lybgicogtmhxnfmx")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qcmbjijoafplpxsh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nlupqmplsxoswyaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        customRules = customRules,
        extendedProperties = extendedProperties,
        location = location,
        managedRules = managedRules,
        policyName = policyName,
        policySettings = policySettings,
        rateLimitRules = rateLimitRules,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
