@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protocol this rule will use when forwarding traffic to backends.
 */
public enum class ForwardingProtocol(
    public val javaValue: com.pulumi.azurenative.cdn.enums.ForwardingProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.ForwardingProtocol> {
    HttpOnly(com.pulumi.azurenative.cdn.enums.ForwardingProtocol.HttpOnly),
    HttpsOnly(com.pulumi.azurenative.cdn.enums.ForwardingProtocol.HttpsOnly),
    MatchRequest(com.pulumi.azurenative.cdn.enums.ForwardingProtocol.MatchRequest),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.ForwardingProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.ForwardingProtocol):
            ForwardingProtocol = ForwardingProtocol.values().first { it.javaValue == javaType }
    }
}
