@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType> {
    None(com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.ManagedServiceIdentityType):
            ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
