@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The protocol of an established TLS connection.
 */
public enum class SslProtocol(
    public val javaValue: com.pulumi.azurenative.cdn.enums.SslProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.SslProtocol> {
    TLSv1(com.pulumi.azurenative.cdn.enums.SslProtocol.TLSv1),
    TLSv1_1(com.pulumi.azurenative.cdn.enums.SslProtocol.TLSv1_1),
    TLSv1_2(com.pulumi.azurenative.cdn.enums.SslProtocol.TLSv1_2),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.SslProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.SslProtocol): SslProtocol =
            SslProtocol.values().first { it.javaValue == javaType }
    }
}
