@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what transforms were applied before matching.
 */
public enum class TransformType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.TransformType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.TransformType> {
    Lowercase(com.pulumi.azurenative.cdn.enums.TransformType.Lowercase),
    Uppercase(com.pulumi.azurenative.cdn.enums.TransformType.Uppercase),
    Trim(com.pulumi.azurenative.cdn.enums.TransformType.Trim),
    UrlDecode(com.pulumi.azurenative.cdn.enums.TransformType.UrlDecode),
    UrlEncode(com.pulumi.azurenative.cdn.enums.TransformType.UrlEncode),
    RemoveNulls(com.pulumi.azurenative.cdn.enums.TransformType.RemoveNulls),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.TransformType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.TransformType): TransformType =
            TransformType.values().first { it.javaValue == javaType }
    }
}
