@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.AfdRouteCacheConfigurationArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.AfdQueryStringCachingBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property compressionSettings compression settings.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringCachingBehavior Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public data class AfdRouteCacheConfigurationArgs(
    public val compressionSettings: Output<CompressionSettingsArgs>? = null,
    public val queryParameters: Output<String>? = null,
    public val queryStringCachingBehavior: Output<Either<String, AfdQueryStringCachingBehavior>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.AfdRouteCacheConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.AfdRouteCacheConfigurationArgs =
        com.pulumi.azurenative.cdn.inputs.AfdRouteCacheConfigurationArgs.builder()
            .compressionSettings(
                compressionSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .queryParameters(queryParameters?.applyValue({ args0 -> args0 }))
            .queryStringCachingBehavior(
                queryStringCachingBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AfdRouteCacheConfigurationArgs].
 */
@PulumiTagMarker
public class AfdRouteCacheConfigurationArgsBuilder internal constructor() {
    private var compressionSettings: Output<CompressionSettingsArgs>? = null

    private var queryParameters: Output<String>? = null

    private var queryStringCachingBehavior: Output<Either<String, AfdQueryStringCachingBehavior>>? =
        null

    /**
     * @param value compression settings.
     */
    @JvmName("pgumonjrcgqfpngt")
    public suspend fun compressionSettings(`value`: Output<CompressionSettingsArgs>) {
        this.compressionSettings = value
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("lxlvvdanjmjngltr")
    public suspend fun queryParameters(`value`: Output<String>) {
        this.queryParameters = value
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("dfhnanvwlbvcslup")
    public suspend
    fun queryStringCachingBehavior(`value`: Output<Either<String, AfdQueryStringCachingBehavior>>) {
        this.queryStringCachingBehavior = value
    }

    /**
     * @param value compression settings.
     */
    @JvmName("eudnehomdcqyblfq")
    public suspend fun compressionSettings(`value`: CompressionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionSettings = mapped
    }

    /**
     * @param argument compression settings.
     */
    @JvmName("wjpoaqxvgqgpaaxb")
    public suspend
    fun compressionSettings(argument: suspend CompressionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CompressionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compressionSettings = mapped
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("brqxjdesjuuglpib")
    public suspend fun queryParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("afufakrtqvbkfffb")
    public suspend
    fun queryStringCachingBehavior(`value`: Either<String, AfdQueryStringCachingBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("edpqlyfdufsgmfim")
    public fun queryStringCachingBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AfdQueryStringCachingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("slrxvtbhilccxxvy")
    public fun queryStringCachingBehavior(`value`: AfdQueryStringCachingBehavior) {
        val toBeMapped = Either.ofRight<String, AfdQueryStringCachingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    internal fun build(): AfdRouteCacheConfigurationArgs = AfdRouteCacheConfigurationArgs(
        compressionSettings = compressionSettings,
        queryParameters = queryParameters,
        queryStringCachingBehavior = queryStringCachingBehavior,
    )
}
