@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CacheExpirationActionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.CacheBehavior
import com.pulumi.azurenative.cdn.kotlin.enums.CacheType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the cache expiration action.
 * @property cacheBehavior Caching behavior for the requests
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
 * @property cacheType The level at which the content needs to be cached.
 * @property typeName
 */
public data class CacheExpirationActionParametersArgs(
    public val cacheBehavior: Output<Either<String, CacheBehavior>>,
    public val cacheDuration: Output<String>? = null,
    public val cacheType: Output<Either<String, CacheType>>,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CacheExpirationActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CacheExpirationActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.CacheExpirationActionParametersArgs.builder()
            .cacheBehavior(
                cacheBehavior.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cacheDuration(cacheDuration?.applyValue({ args0 -> args0 }))
            .cacheType(
                cacheType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheExpirationActionParametersArgs].
 */
@PulumiTagMarker
public class CacheExpirationActionParametersArgsBuilder internal constructor() {
    private var cacheBehavior: Output<Either<String, CacheBehavior>>? = null

    private var cacheDuration: Output<String>? = null

    private var cacheType: Output<Either<String, CacheType>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("vrwichcvccnhjtjf")
    public suspend fun cacheBehavior(`value`: Output<Either<String, CacheBehavior>>) {
        this.cacheBehavior = value
    }

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
     */
    @JvmName("apmigjiubmcpqofh")
    public suspend fun cacheDuration(`value`: Output<String>) {
        this.cacheDuration = value
    }

    /**
     * @param value The level at which the content needs to be cached.
     */
    @JvmName("wrdyixavqncuchip")
    public suspend fun cacheType(`value`: Output<Either<String, CacheType>>) {
        this.cacheType = value
    }

    /**
     * @param value
     */
    @JvmName("kflddlackdyltndf")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("kcbykuwenooqgikc")
    public suspend fun cacheBehavior(`value`: Either<String, CacheBehavior>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("rwuvdjiduybecktw")
    public fun cacheBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CacheBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("rvtwpvmrjhqsjshk")
    public fun cacheBehavior(`value`: CacheBehavior) {
        val toBeMapped = Either.ofRight<String, CacheBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
     */
    @JvmName("sbyyijptmyqcncma")
    public suspend fun cacheDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDuration = mapped
    }

    /**
     * @param value The level at which the content needs to be cached.
     */
    @JvmName("vmafxwmktuynkevl")
    public suspend fun cacheType(`value`: Either<String, CacheType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheType = mapped
    }

    /**
     * @param value The level at which the content needs to be cached.
     */
    @JvmName("ghunjnxfwimhlhad")
    public fun cacheType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CacheType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheType = mapped
    }

    /**
     * @param value The level at which the content needs to be cached.
     */
    @JvmName("tpunqgenebtnepmp")
    public fun cacheType(`value`: CacheType) {
        val toBeMapped = Either.ofRight<String, CacheType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheType = mapped
    }

    /**
     * @param value
     */
    @JvmName("jvbmmkihwjrixqrh")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): CacheExpirationActionParametersArgs = CacheExpirationActionParametersArgs(
        cacheBehavior = cacheBehavior ?: throw PulumiNullFieldException("cacheBehavior"),
        cacheDuration = cacheDuration,
        cacheType = cacheType ?: throw PulumiNullFieldException("cacheType"),
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
