@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A rule that specifies a set of actions and conditions
 * @property actions A list of actions that are executed when all the conditions of a rule are satisfied.
 * @property conditions A list of conditions that must be matched for the actions to be executed
 * @property name Name of the rule
 * @property order The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
 */
public data class DeliveryRuleArgs(
    public val actions: Output<List<Any>>,
    public val conditions: Output<List<Any>>? = null,
    public val name: Output<String>? = null,
    public val order: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .conditions(conditions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .order(order.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeliveryRuleArgs].
 */
@PulumiTagMarker
public class DeliveryRuleArgsBuilder internal constructor() {
    private var actions: Output<List<Any>>? = null

    private var conditions: Output<List<Any>>? = null

    private var name: Output<String>? = null

    private var order: Output<Int>? = null

    /**
     * @param value A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("fgetuawmeooltija")
    public suspend fun actions(`value`: Output<List<Any>>) {
        this.actions = value
    }

    @JvmName("cohdvttikkpflefl")
    public suspend fun actions(vararg values: Output<Any>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("ydfaymtpccnnfkxt")
    public suspend fun actions(values: List<Output<Any>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("lopwnkocyeyjptsl")
    public suspend fun conditions(`value`: Output<List<Any>>) {
        this.conditions = value
    }

    @JvmName("jhxetogaosyqmnxc")
    public suspend fun conditions(vararg values: Output<Any>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("wogvfpsjpidjvnoj")
    public suspend fun conditions(values: List<Output<Any>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value Name of the rule
     */
    @JvmName("gchulaoloplkgopg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
     */
    @JvmName("vrpguopxdwudehnc")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("qeaibnotvdkgnssr")
    public suspend fun actions(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("jvsckprxvotdofhb")
    public suspend fun actions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("fsbxmfqwvgmhpkce")
    public suspend fun conditions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param values A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("vgvibfelddpenvac")
    public suspend fun conditions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Name of the rule
     */
    @JvmName("uaqbqmnmtnchkevi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
     */
    @JvmName("ydysvqunwqjufxwj")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    internal fun build(): DeliveryRuleArgs = DeliveryRuleArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        conditions = conditions,
        name = name,
        order = order ?: throw PulumiNullFieldException("order"),
    )
}
