@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleCookiesConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the Cookies condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'Cookies'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleCookiesConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<CookiesMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleCookiesConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleCookiesConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleCookiesConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleCookiesConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleCookiesConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<CookiesMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'Cookies'.
     */
    @JvmName("icaagrdqjtmibjxo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("haeasaitimjkdwae")
    public suspend fun parameters(`value`: Output<CookiesMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'Cookies'.
     */
    @JvmName("hfvmpigsfaorstrw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("ufdhcmophyevgftc")
    public suspend fun parameters(`value`: CookiesMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("dmknmapdsusfsjes")
    public suspend
    fun parameters(argument: suspend CookiesMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = CookiesMatchConditionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleCookiesConditionArgs = DeliveryRuleCookiesConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
