@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestBodyConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RequestBody condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestBody'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestBodyConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RequestBodyMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestBodyConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestBodyConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestBodyConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestBodyConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestBodyConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RequestBodyMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestBody'.
     */
    @JvmName("uqjlnbqjyanmofqs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("bjyhoklsfshryhvy")
    public suspend fun parameters(`value`: Output<RequestBodyMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestBody'.
     */
    @JvmName("orsdcxtjmhmqnrym")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("ibaembaojuqfbglg")
    public suspend fun parameters(`value`: RequestBodyMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("hhldroaxathhwglc")
    public suspend
    fun parameters(argument: suspend RequestBodyMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RequestBodyMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestBodyConditionArgs = DeliveryRuleRequestBodyConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
