@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestUriConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RequestUri condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestUri'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestUriConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RequestUriMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestUriConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestUriConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestUriConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestUriConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestUriConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RequestUriMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestUri'.
     */
    @JvmName("gjgmslnnedfsrvmt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("ggmpriygrgnargyh")
    public suspend fun parameters(`value`: Output<RequestUriMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestUri'.
     */
    @JvmName("ftyywmekcqftktqn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("geejfstfsqxbyamn")
    public suspend fun parameters(`value`: RequestUriMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("eqgqtvinbcvidieh")
    public suspend
    fun parameters(argument: suspend RequestUriMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RequestUriMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestUriConditionArgs = DeliveryRuleRequestUriConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
