@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleSslProtocolConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the SslProtocol condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'SslProtocol'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleSslProtocolConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<SslProtocolMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleSslProtocolConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleSslProtocolConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleSslProtocolConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleSslProtocolConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleSslProtocolConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<SslProtocolMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'SslProtocol'.
     */
    @JvmName("wilfxfauffpvbxlv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("heobgyaswqtpurii")
    public suspend fun parameters(`value`: Output<SslProtocolMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'SslProtocol'.
     */
    @JvmName("bbqwhxdogtmknpct")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("hnubggjhoqbdukan")
    public suspend fun parameters(`value`: SslProtocolMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("ackbbqptyboynsgo")
    public suspend
    fun parameters(argument: suspend SslProtocolMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = SslProtocolMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleSslProtocolConditionArgs = DeliveryRuleSslProtocolConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
