@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileExtensionConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the UrlFileExtension condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlFileExtension'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlFileExtensionConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlFileExtensionMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileExtensionConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileExtensionConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileExtensionConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleUrlFileExtensionConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleUrlFileExtensionConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlFileExtensionMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlFileExtension'.
     */
    @JvmName("okgyqliqenabjqsl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("fxxnqvqonlkefxks")
    public suspend fun parameters(`value`: Output<UrlFileExtensionMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlFileExtension'.
     */
    @JvmName("omvtbmlnicugtqcq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("cfcaaeoujhdkacmc")
    public suspend fun parameters(`value`: UrlFileExtensionMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("xaddvbsqhahqyxyw")
    public suspend
    fun parameters(argument: suspend UrlFileExtensionMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlFileExtensionMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleUrlFileExtensionConditionArgs =
        DeliveryRuleUrlFileExtensionConditionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
