@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetAFDEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetAFDEndpointPlainArgs(
    public val endpointName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetAFDEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetAFDEndpointPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetAFDEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAFDEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetAFDEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("icrulkwfcoatvugr")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("qqiohmjsyhrxggbl")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("chrawpftyitptcue")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAFDEndpointPlainArgs = GetAFDEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
