@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetOriginPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property originName Name of the origin which is unique within the endpoint.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetOriginPlainArgs(
    public val endpointName: String,
    public val originName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetOriginPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetOriginPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetOriginPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .originName(originName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOriginPlainArgs].
 */
@PulumiTagMarker
public class GetOriginPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var originName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("tcuediuduhagtgqm")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value Name of the origin which is unique within the endpoint.
     */
    @JvmName("tumaibphoxumnofc")
    public suspend fun originName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.originName = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("dlumwpunxnybubea")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("lhuhxyoiklsjyvcs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOriginPlainArgs = GetOriginPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        originName = originName ?: throw PulumiNullFieldException("originName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
