@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyName The name of the CdnWebApplicationFirewallPolicy.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetPolicyPlainArgs(
    public val policyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetPolicyPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetPolicyPlainArgs.builder()
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyPlainArgsBuilder internal constructor() {
    private var policyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the CdnWebApplicationFirewallPolicy.
     */
    @JvmName("fmkagrdcyxkhclwr")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("inlfhnequcyulapw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPolicyPlainArgs = GetPolicyPlainArgs(
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
