@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property ruleName Name of the delivery rule which is unique within the endpoint.
 * @property ruleSetName Name of the rule set under the profile.
 */
public data class GetRulePlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
    public val ruleName: String,
    public val ruleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetRulePlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetRulePlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 }))
            .ruleSetName(ruleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulePlainArgs].
 */
@PulumiTagMarker
public class GetRulePlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    private var ruleSetName: String? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("einjepequhaixcfm")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("anadyimrndaegkud")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the delivery rule which is unique within the endpoint.
     */
    @JvmName("jokmgrcblowhhbes")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    /**
     * @param value Name of the rule set under the profile.
     */
    @JvmName("sofgfbqefijjxyet")
    public suspend fun ruleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleSetName = mapped
    }

    internal fun build(): GetRulePlainArgs = GetRulePlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        ruleSetName = ruleSetName ?: throw PulumiNullFieldException("ruleSetName"),
    )
}
