@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetSecretPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property secretName Name of the Secret under the profile.
 */
public data class GetSecretPlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
    public val secretName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetSecretPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetSecretPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetSecretPlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .secretName(secretName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretPlainArgs].
 */
@PulumiTagMarker
public class GetSecretPlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    private var secretName: String? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("ddofmfktcwcuqkbr")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("coyfmqvhkcjjxgod")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Secret under the profile.
     */
    @JvmName("lvtjcerghcvbmsbb")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretName = mapped
    }

    internal fun build(): GetSecretPlainArgs = GetSecretPlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
    )
}
