@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ManagedRuleGroupOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group override setting.
 * @property ruleGroupName Describes the managed rule group within the rule set to override
 * @property rules List of rules that will be enabled. If none specified, all rules in the group will be disabled.
 */
public data class ManagedRuleGroupOverrideArgs(
    public val ruleGroupName: Output<String>,
    public val rules: Output<List<ManagedRuleOverrideArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ManagedRuleGroupOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ManagedRuleGroupOverrideArgs =
        com.pulumi.azurenative.cdn.inputs.ManagedRuleGroupOverrideArgs.builder()
            .ruleGroupName(ruleGroupName.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedRuleGroupOverrideArgs].
 */
@PulumiTagMarker
public class ManagedRuleGroupOverrideArgsBuilder internal constructor() {
    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<ManagedRuleOverrideArgs>>? = null

    /**
     * @param value Describes the managed rule group within the rule set to override
     */
    @JvmName("vvhnfmqgewgnvwyg")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("scyltqlujpqnvpya")
    public suspend fun rules(`value`: Output<List<ManagedRuleOverrideArgs>>) {
        this.rules = value
    }

    @JvmName("lxtidpylnvpbvlyi")
    public suspend fun rules(vararg values: Output<ManagedRuleOverrideArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("oqnrjqfrnvlfgbam")
    public suspend fun rules(values: List<Output<ManagedRuleOverrideArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Describes the managed rule group within the rule set to override
     */
    @JvmName("ujbwewfxofivdauh")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("eowvfojiayhtsbpf")
    public suspend fun rules(`value`: List<ManagedRuleOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("ektncxptvbybqdnc")
    public suspend fun rules(argument: List<suspend ManagedRuleOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("qqjxqyxsyhxwsqbj")
    public suspend fun rules(vararg argument: suspend ManagedRuleOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedRuleOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("mflsunokjxybuqjc")
    public suspend fun rules(argument: suspend ManagedRuleOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleOverrideArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("jtrcknmauhuvtvpu")
    public suspend fun rules(vararg values: ManagedRuleOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ManagedRuleGroupOverrideArgs = ManagedRuleGroupOverrideArgs(
        ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
        rules = rules,
    )
}
