@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ManagedRuleOverrideArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ActionType
import com.pulumi.azurenative.cdn.kotlin.enums.ManagedRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property enabledState Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
 * @property ruleId Identifier for the managed rule.
 */
public data class ManagedRuleOverrideArgs(
    public val action: Output<Either<String, ActionType>>? = null,
    public val enabledState: Output<Either<String, ManagedRuleEnabledState>>? = null,
    public val ruleId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ManagedRuleOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ManagedRuleOverrideArgs =
        com.pulumi.azurenative.cdn.inputs.ManagedRuleOverrideArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleId(ruleId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedRuleOverrideArgs].
 */
@PulumiTagMarker
public class ManagedRuleOverrideArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var enabledState: Output<Either<String, ManagedRuleEnabledState>>? = null

    private var ruleId: Output<String>? = null

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("qlyccwmcrnlycxbc")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("epjlmmafpkcgytht")
    public suspend fun enabledState(`value`: Output<Either<String, ManagedRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("rnpgwonuofqjapbu")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("dydamjntbclvmymo")
    public suspend fun action(`value`: Either<String, ActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("qsegxibigusmwxrc")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("vpcpotapnbltlbqt")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("bakwfpdhbsueyyaa")
    public suspend fun enabledState(`value`: Either<String, ManagedRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("atgyngcjwijxnvfi")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("ayktinfswlyuhnml")
    public fun enabledState(`value`: ManagedRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("djsqhascmfftqqgd")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    internal fun build(): ManagedRuleOverrideArgs = ManagedRuleOverrideArgs(
        action = action,
        enabledState = enabledState,
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
    )
}
