@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ManagedRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule set.
 * @property anomalyScore Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
 * @property ruleGroupOverrides Defines the rule overrides to apply to the rule set.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class ManagedRuleSetArgs(
    public val anomalyScore: Output<Int>? = null,
    public val ruleGroupOverrides: Output<List<ManagedRuleGroupOverrideArgs>>? = null,
    public val ruleSetType: Output<String>,
    public val ruleSetVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ManagedRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ManagedRuleSetArgs =
        com.pulumi.azurenative.cdn.inputs.ManagedRuleSetArgs.builder()
            .anomalyScore(anomalyScore?.applyValue({ args0 -> args0 }))
            .ruleGroupOverrides(
                ruleGroupOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleSetType(ruleSetType.applyValue({ args0 -> args0 }))
            .ruleSetVersion(ruleSetVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedRuleSetArgs].
 */
@PulumiTagMarker
public class ManagedRuleSetArgsBuilder internal constructor() {
    private var anomalyScore: Output<Int>? = null

    private var ruleGroupOverrides: Output<List<ManagedRuleGroupOverrideArgs>>? = null

    private var ruleSetType: Output<String>? = null

    private var ruleSetVersion: Output<String>? = null

    /**
     * @param value Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
     */
    @JvmName("erfkdaarwjvsiqjj")
    public suspend fun anomalyScore(`value`: Output<Int>) {
        this.anomalyScore = value
    }

    /**
     * @param value Defines the rule overrides to apply to the rule set.
     */
    @JvmName("gkvaxiggmaergwck")
    public suspend fun ruleGroupOverrides(`value`: Output<List<ManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = value
    }

    @JvmName("rghtqxomxctkixjh")
    public suspend fun ruleGroupOverrides(vararg values: Output<ManagedRuleGroupOverrideArgs>) {
        this.ruleGroupOverrides = Output.all(values.asList())
    }

    /**
     * @param values Defines the rule overrides to apply to the rule set.
     */
    @JvmName("fwurwobjuowhohob")
    public suspend fun ruleGroupOverrides(values: List<Output<ManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = Output.all(values)
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("fimlsaouqrbffvmc")
    public suspend fun ruleSetType(`value`: Output<String>) {
        this.ruleSetType = value
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("srdfugysnmkednqa")
    public suspend fun ruleSetVersion(`value`: Output<String>) {
        this.ruleSetVersion = value
    }

    /**
     * @param value Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
     */
    @JvmName("urjahedpdrcjujkb")
    public suspend fun anomalyScore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anomalyScore = mapped
    }

    /**
     * @param value Defines the rule overrides to apply to the rule set.
     */
    @JvmName("rtapoegghkmchfqc")
    public suspend fun ruleGroupOverrides(`value`: List<ManagedRuleGroupOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule overrides to apply to the rule set.
     */
    @JvmName("xdbfpkomdhnpaclx")
    public suspend
    fun ruleGroupOverrides(argument: List<suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule overrides to apply to the rule set.
     */
    @JvmName("ctqihnseacvkmnbp")
    public suspend fun ruleGroupOverrides(
        vararg
        argument: suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule overrides to apply to the rule set.
     */
    @JvmName("pnybpmdahgckwhlh")
    public suspend
    fun ruleGroupOverrides(argument: suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param values Defines the rule overrides to apply to the rule set.
     */
    @JvmName("vdctiysccvjwqvth")
    public suspend fun ruleGroupOverrides(vararg values: ManagedRuleGroupOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("pxsmmsnomvqunsqd")
    public suspend fun ruleSetType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetType = mapped
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("ergfguovjwsbhbad")
    public suspend fun ruleSetVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetVersion = mapped
    }

    internal fun build(): ManagedRuleSetArgs = ManagedRuleSetArgs(
        anomalyScore = anomalyScore,
        ruleGroupOverrides = ruleGroupOverrides,
        ruleSetType = ruleSetType ?: throw PulumiNullFieldException("ruleSetType"),
        ruleSetVersion = ruleSetVersion ?: throw PulumiNullFieldException("ruleSetVersion"),
    )
}
