@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.PolicyEnabledState
import com.pulumi.azurenative.cdn.kotlin.enums.PolicyMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines contents of a web application firewall global configuration
 * @property defaultCustomBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property defaultCustomBlockResponseStatusCode If the action type is block, this field defines the default customer overridable http response status code.
 * @property defaultRedirectUrl If action type is redirect, this field represents the default redirect URL for the client.
 * @property enabledState describes if the policy is in enabled state or disabled state
 * @property mode Describes if it is in detection mode or prevention mode at policy level.
 */
public data class PolicySettingsArgs(
    public val defaultCustomBlockResponseBody: Output<String>? = null,
    public val defaultCustomBlockResponseStatusCode: Output<Int>? = null,
    public val defaultRedirectUrl: Output<String>? = null,
    public val enabledState: Output<Either<String, PolicyEnabledState>>? = null,
    public val mode: Output<Either<String, PolicyMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs =
        com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs.builder()
            .defaultCustomBlockResponseBody(defaultCustomBlockResponseBody?.applyValue({ args0 -> args0 }))
            .defaultCustomBlockResponseStatusCode(
                defaultCustomBlockResponseStatusCode?.applyValue({ args0 ->
                    args0
                }),
            )
            .defaultRedirectUrl(defaultRedirectUrl?.applyValue({ args0 -> args0 }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySettingsArgs].
 */
@PulumiTagMarker
public class PolicySettingsArgsBuilder internal constructor() {
    private var defaultCustomBlockResponseBody: Output<String>? = null

    private var defaultCustomBlockResponseStatusCode: Output<Int>? = null

    private var defaultRedirectUrl: Output<String>? = null

    private var enabledState: Output<Either<String, PolicyEnabledState>>? = null

    private var mode: Output<Either<String, PolicyMode>>? = null

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("ycvgcorxopqkjglg")
    public suspend fun defaultCustomBlockResponseBody(`value`: Output<String>) {
        this.defaultCustomBlockResponseBody = value
    }

    /**
     * @param value If the action type is block, this field defines the default customer overridable http response status code.
     */
    @JvmName("iwcxyyclpdaivpqk")
    public suspend fun defaultCustomBlockResponseStatusCode(`value`: Output<Int>) {
        this.defaultCustomBlockResponseStatusCode = value
    }

    /**
     * @param value If action type is redirect, this field represents the default redirect URL for the client.
     */
    @JvmName("ejowddrqxlddgivo")
    public suspend fun defaultRedirectUrl(`value`: Output<String>) {
        this.defaultRedirectUrl = value
    }

    /**
     * @param value describes if the policy is in enabled state or disabled state
     */
    @JvmName("hlsavusomijauloh")
    public suspend fun enabledState(`value`: Output<Either<String, PolicyEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("hwlwchqfwatxrtqe")
    public suspend fun mode(`value`: Output<Either<String, PolicyMode>>) {
        this.mode = value
    }

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("lqcwnbkhqrniquey")
    public suspend fun defaultCustomBlockResponseBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCustomBlockResponseBody = mapped
    }

    /**
     * @param value If the action type is block, this field defines the default customer overridable http response status code.
     */
    @JvmName("fqpsdqntaceguyku")
    public suspend fun defaultCustomBlockResponseStatusCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCustomBlockResponseStatusCode = mapped
    }

    /**
     * @param value If action type is redirect, this field represents the default redirect URL for the client.
     */
    @JvmName("gehdlinbwqsaacbv")
    public suspend fun defaultRedirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRedirectUrl = mapped
    }

    /**
     * @param value describes if the policy is in enabled state or disabled state
     */
    @JvmName("rimhhqgwjuwiywho")
    public suspend fun enabledState(`value`: Either<String, PolicyEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value describes if the policy is in enabled state or disabled state
     */
    @JvmName("jfhpajnhboqwfbin")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value describes if the policy is in enabled state or disabled state
     */
    @JvmName("afgfxyxtohbtokab")
    public fun enabledState(`value`: PolicyEnabledState) {
        val toBeMapped = Either.ofRight<String, PolicyEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("hiuntgswmwuqspkt")
    public suspend fun mode(`value`: Either<String, PolicyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("qoxixkhxjwohlvga")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("rwqrdokmamywkuck")
    public fun mode(`value`: PolicyMode) {
        val toBeMapped = Either.ofRight<String, PolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): PolicySettingsArgs = PolicySettingsArgs(
        defaultCustomBlockResponseBody = defaultCustomBlockResponseBody,
        defaultCustomBlockResponseStatusCode = defaultCustomBlockResponseStatusCode,
        defaultRedirectUrl = defaultRedirectUrl,
        enabledState = enabledState,
        mode = mode,
    )
}
