@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.QueryStringMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.QueryStringOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for QueryString match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class QueryStringMatchConditionParametersArgs(
    public val matchValues: Output<List<String>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, QueryStringOperator>>,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.QueryStringMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.QueryStringMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.QueryStringMatchConditionParametersArgs.builder()
            .matchValues(matchValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueryStringMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class QueryStringMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, QueryStringOperator>>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("jodvjpcovcgjqbxb")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("jgwartoylkiifwyf")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("hsyjmsprjsmoidyh")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("dkdxcjekqlwvomlg")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("jrxywjjugnexiliv")
    public suspend fun `operator`(`value`: Output<Either<String, QueryStringOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("iyeldggruosmfmvu")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("hswymbowacthapdf")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("lniebdlourubpowb")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cwxmnbmshorxmejn")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("mlcbouhuprktleke")
    public suspend fun matchValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("lngnomyoodbyhoht")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("immhkopayxvgllnf")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("berbdraukqqyvfwg")
    public suspend fun `operator`(`value`: Either<String, QueryStringOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("gniulxjygwxharrn")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, QueryStringOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("fmdbsprassjpahrd")
    public fun `operator`(`value`: QueryStringOperator) {
        val toBeMapped = Either.ofRight<String, QueryStringOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("yjdubspfkphyirvn")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("bvygfbqhwyxbjtmg")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("davjemofcgjnrddn")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): QueryStringMatchConditionParametersArgs =
        QueryStringMatchConditionParametersArgs(
            matchValues = matchValues,
            negateCondition = negateCondition,
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            transforms = transforms,
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
