@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ResponseBasedDetectedErrorTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The JSON object that contains the properties to determine origin health using real requests/responses.
 * @property httpErrorRanges The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
 * @property responseBasedDetectedErrorTypes Type of response errors for real user requests for which origin will be deemed unhealthy
 * @property responseBasedFailoverThresholdPercentage The percentage of failed requests in the sample where failover should trigger.
 */
public data class ResponseBasedOriginErrorDetectionParametersArgs(
    public val httpErrorRanges: Output<List<HttpErrorRangeParametersArgs>>? = null,
    public val responseBasedDetectedErrorTypes: Output<ResponseBasedDetectedErrorTypes>? = null,
    public val responseBasedFailoverThresholdPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs.builder()
            .httpErrorRanges(
                httpErrorRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseBasedDetectedErrorTypes(
                responseBasedDetectedErrorTypes?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .responseBasedFailoverThresholdPercentage(
                responseBasedFailoverThresholdPercentage?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ResponseBasedOriginErrorDetectionParametersArgs].
 */
@PulumiTagMarker
public class ResponseBasedOriginErrorDetectionParametersArgsBuilder internal constructor() {
    private var httpErrorRanges: Output<List<HttpErrorRangeParametersArgs>>? = null

    private var responseBasedDetectedErrorTypes: Output<ResponseBasedDetectedErrorTypes>? = null

    private var responseBasedFailoverThresholdPercentage: Output<Int>? = null

    /**
     * @param value The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("vmmvfagsdgmwkiph")
    public suspend fun httpErrorRanges(`value`: Output<List<HttpErrorRangeParametersArgs>>) {
        this.httpErrorRanges = value
    }

    @JvmName("dqydljgqcrniyeft")
    public suspend fun httpErrorRanges(vararg values: Output<HttpErrorRangeParametersArgs>) {
        this.httpErrorRanges = Output.all(values.asList())
    }

    /**
     * @param values The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("famkmgdjosytqfxv")
    public suspend fun httpErrorRanges(values: List<Output<HttpErrorRangeParametersArgs>>) {
        this.httpErrorRanges = Output.all(values)
    }

    /**
     * @param value Type of response errors for real user requests for which origin will be deemed unhealthy
     */
    @JvmName("gtqjgamqycuxmpsb")
    public suspend
    fun responseBasedDetectedErrorTypes(`value`: Output<ResponseBasedDetectedErrorTypes>) {
        this.responseBasedDetectedErrorTypes = value
    }

    /**
     * @param value The percentage of failed requests in the sample where failover should trigger.
     */
    @JvmName("pvkkdphxbkweoksg")
    public suspend fun responseBasedFailoverThresholdPercentage(`value`: Output<Int>) {
        this.responseBasedFailoverThresholdPercentage = value
    }

    /**
     * @param value The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("yytmliapprwesill")
    public suspend fun httpErrorRanges(`value`: List<HttpErrorRangeParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpErrorRanges = mapped
    }

    /**
     * @param argument The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("fjcnbebaudnsidld")
    public suspend
    fun httpErrorRanges(argument: List<suspend HttpErrorRangeParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HttpErrorRangeParametersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpErrorRanges = mapped
    }

    /**
     * @param argument The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("pwoojkslfwncrlct")
    public suspend fun httpErrorRanges(
        vararg
        argument: suspend HttpErrorRangeParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HttpErrorRangeParametersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpErrorRanges = mapped
    }

    /**
     * @param argument The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("hkwbkbhwyayyvvfd")
    public suspend
    fun httpErrorRanges(argument: suspend HttpErrorRangeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HttpErrorRangeParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpErrorRanges = mapped
    }

    /**
     * @param values The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
     */
    @JvmName("tligfsptowqfjraq")
    public suspend fun httpErrorRanges(vararg values: HttpErrorRangeParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpErrorRanges = mapped
    }

    /**
     * @param value Type of response errors for real user requests for which origin will be deemed unhealthy
     */
    @JvmName("kuyfrvquibohccoy")
    public suspend fun responseBasedDetectedErrorTypes(`value`: ResponseBasedDetectedErrorTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseBasedDetectedErrorTypes = mapped
    }

    /**
     * @param value The percentage of failed requests in the sample where failover should trigger.
     */
    @JvmName("cnoutlkmfdadkfgy")
    public suspend fun responseBasedFailoverThresholdPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseBasedFailoverThresholdPercentage = mapped
    }

    internal fun build(): ResponseBasedOriginErrorDetectionParametersArgs =
        ResponseBasedOriginErrorDetectionParametersArgs(
            httpErrorRanges = httpErrorRanges,
            responseBasedDetectedErrorTypes = responseBasedDetectedErrorTypes,
            responseBasedFailoverThresholdPercentage = responseBasedFailoverThresholdPercentage,
        )
}
