@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * settings for security policy patterns to match
 * @property domains List of domains.
 * @property patternsToMatch List of paths
 */
public data class SecurityPolicyWebApplicationFirewallAssociationArgs(
    public val domains: Output<List<ActivatedResourceReferenceArgs>>? = null,
    public val patternsToMatch: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallAssociationArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallAssociationArgs =
        com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallAssociationArgs.builder()
            .domains(
                domains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .patternsToMatch(patternsToMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecurityPolicyWebApplicationFirewallAssociationArgs].
 */
@PulumiTagMarker
public class SecurityPolicyWebApplicationFirewallAssociationArgsBuilder internal constructor() {
    private var domains: Output<List<ActivatedResourceReferenceArgs>>? = null

    private var patternsToMatch: Output<List<String>>? = null

    /**
     * @param value List of domains.
     */
    @JvmName("skrwauhgafbhcalj")
    public suspend fun domains(`value`: Output<List<ActivatedResourceReferenceArgs>>) {
        this.domains = value
    }

    @JvmName("jmhaiyvbtbcshdub")
    public suspend fun domains(vararg values: Output<ActivatedResourceReferenceArgs>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values List of domains.
     */
    @JvmName("hrxfodieanhlkaek")
    public suspend fun domains(values: List<Output<ActivatedResourceReferenceArgs>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value List of paths
     */
    @JvmName("vequukfdyjvjmmtk")
    public suspend fun patternsToMatch(`value`: Output<List<String>>) {
        this.patternsToMatch = value
    }

    @JvmName("gudwrwrjsarrndwm")
    public suspend fun patternsToMatch(vararg values: Output<String>) {
        this.patternsToMatch = Output.all(values.asList())
    }

    /**
     * @param values List of paths
     */
    @JvmName("nncoihnfrkanlihi")
    public suspend fun patternsToMatch(values: List<Output<String>>) {
        this.patternsToMatch = Output.all(values)
    }

    /**
     * @param value List of domains.
     */
    @JvmName("pkpbhenkjafppvrc")
    public suspend fun domains(`value`: List<ActivatedResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param argument List of domains.
     */
    @JvmName("fhinqumhffwaxmec")
    public suspend
    fun domains(argument: List<suspend ActivatedResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.domains = mapped
    }

    /**
     * @param argument List of domains.
     */
    @JvmName("rvjetmceyjmcwkyj")
    public suspend fun domains(
        vararg
        argument: suspend ActivatedResourceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.domains = mapped
    }

    /**
     * @param argument List of domains.
     */
    @JvmName("lrywrnkbbxaajcea")
    public suspend fun domains(argument: suspend ActivatedResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.domains = mapped
    }

    /**
     * @param values List of domains.
     */
    @JvmName("sqgipuyuwockkyps")
    public suspend fun domains(vararg values: ActivatedResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value List of paths
     */
    @JvmName("vfxhytjawbvxahiv")
    public suspend fun patternsToMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    /**
     * @param values List of paths
     */
    @JvmName("cxeunhkgubvrxwmr")
    public suspend fun patternsToMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    internal fun build(): SecurityPolicyWebApplicationFirewallAssociationArgs =
        SecurityPolicyWebApplicationFirewallAssociationArgs(
            domains = domains,
            patternsToMatch = patternsToMatch,
        )
}
