@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlRedirectActionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.DestinationProtocol
import com.pulumi.azurenative.cdn.kotlin.enums.RedirectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the url redirect action.
 * @property customFragment Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
 * @property customHostname Host to redirect. Leave empty to use the incoming host as the destination host.
 * @property customPath The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
 * @property customQueryString The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
 * @property destinationProtocol Protocol to use for the redirect. The default value is MatchRequest
 * @property redirectType The redirect type the rule will use when redirecting traffic.
 * @property typeName
 */
public data class UrlRedirectActionParametersArgs(
    public val customFragment: Output<String>? = null,
    public val customHostname: Output<String>? = null,
    public val customPath: Output<String>? = null,
    public val customQueryString: Output<String>? = null,
    public val destinationProtocol: Output<Either<String, DestinationProtocol>>? = null,
    public val redirectType: Output<Either<String, RedirectType>>,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlRedirectActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlRedirectActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.UrlRedirectActionParametersArgs.builder()
            .customFragment(customFragment?.applyValue({ args0 -> args0 }))
            .customHostname(customHostname?.applyValue({ args0 -> args0 }))
            .customPath(customPath?.applyValue({ args0 -> args0 }))
            .customQueryString(customQueryString?.applyValue({ args0 -> args0 }))
            .destinationProtocol(
                destinationProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .redirectType(
                redirectType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UrlRedirectActionParametersArgs].
 */
@PulumiTagMarker
public class UrlRedirectActionParametersArgsBuilder internal constructor() {
    private var customFragment: Output<String>? = null

    private var customHostname: Output<String>? = null

    private var customPath: Output<String>? = null

    private var customQueryString: Output<String>? = null

    private var destinationProtocol: Output<Either<String, DestinationProtocol>>? = null

    private var redirectType: Output<Either<String, RedirectType>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
     */
    @JvmName("bomhnnexerucbyfw")
    public suspend fun customFragment(`value`: Output<String>) {
        this.customFragment = value
    }

    /**
     * @param value Host to redirect. Leave empty to use the incoming host as the destination host.
     */
    @JvmName("mtxoyvmyjokteuox")
    public suspend fun customHostname(`value`: Output<String>) {
        this.customHostname = value
    }

    /**
     * @param value The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
     */
    @JvmName("rpukebhblyvkxgje")
    public suspend fun customPath(`value`: Output<String>) {
        this.customPath = value
    }

    /**
     * @param value The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
     */
    @JvmName("ffitqxjdlrcxpqji")
    public suspend fun customQueryString(`value`: Output<String>) {
        this.customQueryString = value
    }

    /**
     * @param value Protocol to use for the redirect. The default value is MatchRequest
     */
    @JvmName("ignnjpmfaugappxs")
    public suspend fun destinationProtocol(`value`: Output<Either<String, DestinationProtocol>>) {
        this.destinationProtocol = value
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("fxeplywnrtdjdvtt")
    public suspend fun redirectType(`value`: Output<Either<String, RedirectType>>) {
        this.redirectType = value
    }

    /**
     * @param value
     */
    @JvmName("vqkvttydnunbgyni")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
     */
    @JvmName("enoyiaapwehcdrpw")
    public suspend fun customFragment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFragment = mapped
    }

    /**
     * @param value Host to redirect. Leave empty to use the incoming host as the destination host.
     */
    @JvmName("rekelwaunqtulnus")
    public suspend fun customHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostname = mapped
    }

    /**
     * @param value The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
     */
    @JvmName("wvgjtmtxvyfvlkdg")
    public suspend fun customPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPath = mapped
    }

    /**
     * @param value The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
     */
    @JvmName("xvgxllupugtiiobn")
    public suspend fun customQueryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customQueryString = mapped
    }

    /**
     * @param value Protocol to use for the redirect. The default value is MatchRequest
     */
    @JvmName("sexnjpksdlkogjmv")
    public suspend fun destinationProtocol(`value`: Either<String, DestinationProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationProtocol = mapped
    }

    /**
     * @param value Protocol to use for the redirect. The default value is MatchRequest
     */
    @JvmName("iiqcgkxsqjlfhyxy")
    public fun destinationProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DestinationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationProtocol = mapped
    }

    /**
     * @param value Protocol to use for the redirect. The default value is MatchRequest
     */
    @JvmName("yghbcxtjcpgsndyu")
    public fun destinationProtocol(`value`: DestinationProtocol) {
        val toBeMapped = Either.ofRight<String, DestinationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationProtocol = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("fkwqegngervkyqin")
    public suspend fun redirectType(`value`: Either<String, RedirectType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("eakfnnraxrfjwqwv")
    public fun redirectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("xxmsumslhgeqqdaa")
    public fun redirectType(`value`: RedirectType) {
        val toBeMapped = Either.ofRight<String, RedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value
     */
    @JvmName("vufqaxqdxivgsgys")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): UrlRedirectActionParametersArgs = UrlRedirectActionParametersArgs(
        customFragment = customFragment,
        customHostname = customHostname,
        customPath = customPath,
        customQueryString = customQueryString,
        destinationProtocol = destinationProtocol,
        redirectType = redirectType ?: throw PulumiNullFieldException("redirectType"),
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
