@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlSigningKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Url signing key
 * @property keyId Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
 * @property keySourceParameters Defines the parameters for using customer key vault for Url Signing Key.
 */
public data class UrlSigningKeyArgs(
    public val keyId: Output<String>,
    public val keySourceParameters: Output<KeyVaultSigningKeyParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlSigningKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlSigningKeyArgs =
        com.pulumi.azurenative.cdn.inputs.UrlSigningKeyArgs.builder()
            .keyId(keyId.applyValue({ args0 -> args0 }))
            .keySourceParameters(
                keySourceParameters.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UrlSigningKeyArgs].
 */
@PulumiTagMarker
public class UrlSigningKeyArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var keySourceParameters: Output<KeyVaultSigningKeyParametersArgs>? = null

    /**
     * @param value Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     */
    @JvmName("yrawjhjqxjwulevw")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Defines the parameters for using customer key vault for Url Signing Key.
     */
    @JvmName("gosnwvkvrhuxmxdc")
    public suspend fun keySourceParameters(`value`: Output<KeyVaultSigningKeyParametersArgs>) {
        this.keySourceParameters = value
    }

    /**
     * @param value Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     */
    @JvmName("hfxpdsalbesvdgwr")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Defines the parameters for using customer key vault for Url Signing Key.
     */
    @JvmName("hodcdybwiwsndber")
    public suspend fun keySourceParameters(`value`: KeyVaultSigningKeyParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySourceParameters = mapped
    }

    /**
     * @param argument Defines the parameters for using customer key vault for Url Signing Key.
     */
    @JvmName("hasxprvotbpttfoj")
    public suspend
    fun keySourceParameters(argument: suspend KeyVaultSigningKeyParametersArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSigningKeyParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keySourceParameters = mapped
    }

    internal fun build(): UrlSigningKeyArgs = UrlSigningKeyArgs(
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        keySourceParameters = keySourceParameters ?: throw PulumiNullFieldException("keySourceParameters"),
    )
}
