@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.
 * @property certificateAuthority Certificate issuing authority.
 * @property expirationDate Certificate expiration date.
 * @property secretSource Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
 * @property subject Subject name in the certificate.
 * @property subjectAlternativeNames The list of SANs.
 * @property thumbprint Certificate thumbprint.
 * @property type The type of the secret resource.
 * Expected value is 'AzureFirstPartyManagedCertificate'.
 */
public data class AzureFirstPartyManagedCertificateParametersResponse(
    public val certificateAuthority: String,
    public val expirationDate: String,
    public val secretSource: ResourceReferenceResponse,
    public val subject: String,
    public val subjectAlternativeNames: List<String>? = null,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.AzureFirstPartyManagedCertificateParametersResponse):
            AzureFirstPartyManagedCertificateParametersResponse =
            AzureFirstPartyManagedCertificateParametersResponse(
                certificateAuthority = javaType.certificateAuthority(),
                expirationDate = javaType.expirationDate(),
                secretSource = javaType.secretSource().let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                }),
                subject = javaType.subject(),
                subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 -> args0 }),
                thumbprint = javaType.thumbprint(),
                type = javaType.type(),
            )
    }
}
