@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A policy that specifies the delivery rules to be used for an endpoint.
 * @property description User-friendly description of the policy.
 * @property rules A list of the delivery rules.
 */
public data class EndpointPropertiesUpdateParametersResponseDeliveryPolicy(
    public val description: String? = null,
    public val rules: List<DeliveryRuleResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.EndpointPropertiesUpdateParametersResponseDeliveryPolicy):
            EndpointPropertiesUpdateParametersResponseDeliveryPolicy =
            EndpointPropertiesUpdateParametersResponseDeliveryPolicy(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                rules = javaType.rules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.DeliveryRuleResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
