@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
 * @property azureOrigin Resource reference to the Azure origin resource.
 * @property deploymentStatus
 * @property enabledState Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
 * @property enforceCertificateNameCheck Whether to enable certificate name check at origin level
 * @property hostName The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
 * @property httpPort The value of the HTTP port. Must be between 1 and 65535.
 * @property httpsPort The value of the HTTPS port. Must be between 1 and 65535.
 * @property id Resource ID.
 * @property name Resource name.
 * @property originGroupName The name of the origin group which contains this origin.
 * @property originHostHeader The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
 * @property priority Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
 * @property provisioningState Provisioning status
 * @property sharedPrivateLinkResource The properties of the private link resource for private origin.
 * @property systemData Read only system data
 * @property type Resource type.
 * @property weight Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
 */
public data class GetAFDOriginResult(
    public val azureOrigin: ResourceReferenceResponse? = null,
    public val deploymentStatus: String,
    public val enabledState: String? = null,
    public val enforceCertificateNameCheck: Boolean? = null,
    public val hostName: String,
    public val httpPort: Int? = null,
    public val httpsPort: Int? = null,
    public val id: String,
    public val name: String,
    public val originGroupName: String,
    public val originHostHeader: String? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val sharedPrivateLinkResource: SharedPrivateLinkResourcePropertiesResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetAFDOriginResult):
            GetAFDOriginResult = GetAFDOriginResult(
            azureOrigin = javaType.azureOrigin().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentStatus = javaType.deploymentStatus(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            enforceCertificateNameCheck = javaType.enforceCertificateNameCheck().map({ args0 ->
                args0
            }).orElse(null),
            hostName = javaType.hostName(),
            httpPort = javaType.httpPort().map({ args0 -> args0 }).orElse(null),
            httpsPort = javaType.httpsPort().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            originGroupName = javaType.originGroupName(),
            originHostHeader = javaType.originHostHeader().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sharedPrivateLinkResource = javaType.sharedPrivateLinkResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.SharedPrivateLinkResourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
