@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * @property customHttpsParameters Certificate parameters for securing custom HTTPS
 * @property customHttpsProvisioningState Provisioning status of the custom domain.
 * @property customHttpsProvisioningSubstate Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
 * @property hostName The host name of the custom domain. Must be a domain name.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState Provisioning status of Custom Https of the custom domain.
 * @property resourceState Resource status of the custom domain.
 * @property systemData Read only system data
 * @property type Resource type.
 * @property validationData Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
 */
public data class GetCustomDomainResult(
    public val customHttpsParameters:
    Either<CdnManagedHttpsParametersResponse, UserManagedHttpsParametersResponse>? = null,
    public val customHttpsProvisioningState: String,
    public val customHttpsProvisioningSubstate: String,
    public val hostName: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val validationData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetCustomDomainResult):
            GetCustomDomainResult = GetCustomDomainResult(
            customHttpsParameters = javaType.customHttpsParameters().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.cdn.kotlin.outputs.CdnManagedHttpsParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.cdn.kotlin.outputs.UserManagedHttpsParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            customHttpsProvisioningState = javaType.customHttpsProvisioningState(),
            customHttpsProvisioningSubstate = javaType.customHttpsProvisioningSubstate(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            validationData = javaType.validationData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
