@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
 * @property contentTypesToCompress List of content types on which compression applies. The value should be a valid MIME type.
 * @property customDomains The custom domains under the endpoint.
 * @property defaultOriginGroup A reference to the origin group.
 * @property deliveryPolicy A policy that specifies the delivery rules to be used for an endpoint.
 * @property geoFilters List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
 * @property hostName The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
 * @property id Resource ID.
 * @property isCompressionEnabled Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
 * @property isHttpAllowed Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
 * @property isHttpsAllowed Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
 * @property location Resource location.
 * @property name Resource name.
 * @property optimizationType Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
 * @property originGroups The origin groups comprising of origins that are used for load balancing the traffic based on availability.
 * @property originHostHeader The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
 * @property originPath A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
 * @property origins The source of the content being delivered via CDN.
 * @property probePath Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
 * @property provisioningState Provisioning status of the endpoint.
 * @property queryStringCachingBehavior Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
 * @property resourceState Resource status of the endpoint.
 * @property systemData Read only system data
 * @property tags Resource tags.
 * @property type Resource type.
 * @property urlSigningKeys List of keys used to validate the signed URL hashes.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for the endpoint (if applicable)
 */
public data class GetEndpointResult(
    public val contentTypesToCompress: List<String>? = null,
    public val customDomains: List<DeepCreatedCustomDomainResponse>,
    public val defaultOriginGroup: ResourceReferenceResponse? = null,
    public val deliveryPolicy: EndpointPropertiesUpdateParametersResponseDeliveryPolicy? = null,
    public val geoFilters: List<GeoFilterResponse>? = null,
    public val hostName: String,
    public val id: String,
    public val isCompressionEnabled: Boolean? = null,
    public val isHttpAllowed: Boolean? = null,
    public val isHttpsAllowed: Boolean? = null,
    public val location: String,
    public val name: String,
    public val optimizationType: String? = null,
    public val originGroups: List<DeepCreatedOriginGroupResponse>? = null,
    public val originHostHeader: String? = null,
    public val originPath: String? = null,
    public val origins: List<DeepCreatedOriginResponse>,
    public val probePath: String? = null,
    public val provisioningState: String,
    public val queryStringCachingBehavior: String? = null,
    public val resourceState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val urlSigningKeys: List<UrlSigningKeyResponse>? = null,
    public val webApplicationFirewallPolicyLink:
    EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetEndpointResult):
            GetEndpointResult = GetEndpointResult(
            contentTypesToCompress = javaType.contentTypesToCompress().map({ args0 -> args0 }),
            customDomains = javaType.customDomains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedCustomDomainResponse.Companion.toKotlin(args0)
                })
            }),
            defaultOriginGroup = javaType.defaultOriginGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deliveryPolicy = javaType.deliveryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseDeliveryPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            geoFilters = javaType.geoFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.GeoFilterResponse.Companion.toKotlin(args0)
                })
            }),
            hostName = javaType.hostName(),
            id = javaType.id(),
            isCompressionEnabled = javaType.isCompressionEnabled().map({ args0 -> args0 }).orElse(null),
            isHttpAllowed = javaType.isHttpAllowed().map({ args0 -> args0 }).orElse(null),
            isHttpsAllowed = javaType.isHttpsAllowed().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            optimizationType = javaType.optimizationType().map({ args0 -> args0 }).orElse(null),
            originGroups = javaType.originGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginGroupResponse.Companion.toKotlin(args0)
                })
            }),
            originHostHeader = javaType.originHostHeader().map({ args0 -> args0 }).orElse(null),
            originPath = javaType.originPath().map({ args0 -> args0 }).orElse(null),
            origins = javaType.origins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginResponse.Companion.toKotlin(args0)
                })
            }),
            probePath = javaType.probePath().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            queryStringCachingBehavior = javaType.queryStringCachingBehavior().map({ args0 ->
                args0
            }).orElse(null),
            resourceState = javaType.resourceState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            urlSigningKeys = javaType.urlSigningKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.UrlSigningKeyResponse.Companion.toKotlin(args0)
                })
            }),
            webApplicationFirewallPolicyLink = javaType.webApplicationFirewallPolicyLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
