@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains a list of references of UrlSigningKey type secret objects.
 * @property deploymentStatus
 * @property id Resource ID.
 * @property keyReferences Names of UrlSigningKey type secret objects
 * @property name Resource name.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetKeyGroupResult(
    public val deploymentStatus: String,
    public val id: String,
    public val keyReferences: List<ResourceReferenceResponse>? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetKeyGroupResult):
            GetKeyGroupResult = GetKeyGroupResult(
            deploymentStatus = javaType.deploymentStatus(),
            id = javaType.id(),
            keyReferences = javaType.keyReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
