@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed Certificate used for https
 * @property expirationDate Certificate expiration date.
 * @property subject Subject name in the certificate.
 * @property type The type of the secret resource.
 * Expected value is 'ManagedCertificate'.
 */
public data class ManagedCertificateParametersResponse(
    public val expirationDate: String,
    public val subject: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.ManagedCertificateParametersResponse):
            ManagedCertificateParametersResponse = ManagedCertificateParametersResponse(
            expirationDate = javaType.expirationDate(),
            subject = javaType.subject(),
            type = javaType.type(),
        )
    }
}
