@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the origin group override action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'OriginGroupOverride'.
 * @property parameters Defines the parameters for the action.
 */
public data class OriginGroupOverrideActionResponse(
    public val name: String,
    public val parameters: OriginGroupOverrideActionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.OriginGroupOverrideActionResponse):
            OriginGroupOverrideActionResponse = OriginGroupOverrideActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.OriginGroupOverrideActionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
