@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the url redirect action.
 * @property customFragment Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
 * @property customHostname Host to redirect. Leave empty to use the incoming host as the destination host.
 * @property customPath The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
 * @property customQueryString The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
 * @property destinationProtocol Protocol to use for the redirect. The default value is MatchRequest
 * @property redirectType The redirect type the rule will use when redirecting traffic.
 * @property typeName
 */
public data class UrlRedirectActionParametersResponse(
    public val customFragment: String? = null,
    public val customHostname: String? = null,
    public val customPath: String? = null,
    public val customQueryString: String? = null,
    public val destinationProtocol: String? = null,
    public val redirectType: String,
    public val typeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlRedirectActionParametersResponse):
            UrlRedirectActionParametersResponse = UrlRedirectActionParametersResponse(
            customFragment = javaType.customFragment().map({ args0 -> args0 }).orElse(null),
            customHostname = javaType.customHostname().map({ args0 -> args0 }).orElse(null),
            customPath = javaType.customPath().map({ args0 -> args0 }).orElse(null),
            customQueryString = javaType.customQueryString().map({ args0 -> args0 }).orElse(null),
            destinationProtocol = javaType.destinationProtocol().map({ args0 -> args0 }).orElse(null),
            redirectType = javaType.redirectType(),
            typeName = javaType.typeName(),
        )
    }
}
