@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin

import com.pulumi.azurenative.changeanalysis.kotlin.outputs.ConfigurationProfileResourcePropertiesResponse
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.ConfigurationProfileResourcePropertiesResponse.Companion.toKotlin as configurationProfileResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfile].
 */
@PulumiTagMarker
public class ConfigurationProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileArgs = ConfigurationProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationProfile {
        val builtJavaResource =
            com.pulumi.azurenative.changeanalysis.ConfigurationProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfile(builtJavaResource)
    }
}

/**
 * A profile object that contains change analysis configuration, such as notification settings, for this subscription
 * Azure REST API version: 2020-04-01-preview. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### ConfigurationProfile_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfile = new AzureNative.ChangeAnalysis.ConfigurationProfile("configurationProfile", new()
 *     {
 *         ProfileName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/changeanalysis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := changeanalysis.NewConfigurationProfile(ctx, "configurationProfile", &changeanalysis.ConfigurationProfileArgs{
 * 			ProfileName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfile;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfile = new ConfigurationProfile("configurationProfile", ConfigurationProfileArgs.builder()
 *             .profileName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigurationProfile_CreateWithIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfile = new AzureNative.ChangeAnalysis.ConfigurationProfile("configurationProfile", new()
 *     {
 *         ProfileName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/changeanalysis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := changeanalysis.NewConfigurationProfile(ctx, "configurationProfile", &changeanalysis.ConfigurationProfileArgs{
 * 			ProfileName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfile;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfile = new ConfigurationProfile("configurationProfile", ConfigurationProfileArgs.builder()
 *             .profileName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:changeanalysis:ConfigurationProfile default /subscriptions/{subscriptionId}/providers/Microsoft.ChangeAnalysis/profile/{profileName}
 * ```
 */
public class ConfigurationProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.changeanalysis.ConfigurationProfile,
) : KotlinCustomResource(javaResource, ConfigurationProfileMapper) {
    /**
     * The identity block returned by ARM resource that supports managed identity.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location where the resource is to be deployed.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a configuration profile.
     */
    public val properties: Output<ConfigurationProfileResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfileResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
     */
    public val systemData: Output<SystemDataResponse>?
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    systemDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfileMapper : ResourceMapper<ConfigurationProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.changeanalysis.ConfigurationProfile::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfile = ConfigurationProfile(
        javaResource
            as com.pulumi.azurenative.changeanalysis.ConfigurationProfile,
    )
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfile].
 */
public suspend fun configurationProfile(
    name: String,
    block: suspend ConfigurationProfileResourceBuilder.() -> Unit,
): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfile(name: String): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
