@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.kotlin.outputs.ExperimentPropertiesResponse
import com.pulumi.azurenative.chaos.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.chaos.kotlin.outputs.ExperimentPropertiesResponse.Companion.toKotlin as experimentPropertiesResponseToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Experiment].
 */
@PulumiTagMarker
public class ExperimentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExperimentArgs = ExperimentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExperimentArgsBuilder.() -> Unit) {
        val builder = ExperimentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Experiment {
        val builtJavaResource = com.pulumi.azurenative.chaos.Experiment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Experiment(builtJavaResource)
    }
}

/**
 * Model that represents a Experiment resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01, 2024-01-01.
 */
public class Experiment internal constructor(
    override val javaResource: com.pulumi.azurenative.chaos.Experiment,
) : KotlinCustomResource(javaResource, ExperimentMapper) {
    /**
     * The identity of the experiment resource.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the experiment resource.
     */
    public val properties: Output<ExperimentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                experimentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata of the experiment resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExperimentMapper : ResourceMapper<Experiment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.chaos.Experiment::class == javaResource::class

    override fun map(javaResource: Resource): Experiment = Experiment(
        javaResource as
            com.pulumi.azurenative.chaos.Experiment,
    )
}

/**
 * @see [Experiment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Experiment].
 */
public suspend fun experiment(name: String, block: suspend ExperimentResourceBuilder.() -> Unit):
    Experiment {
    val builder = ExperimentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Experiment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun experiment(name: String): Experiment {
    val builder = ExperimentResourceBuilder()
    builder.name(name)
    return builder.build()
}
